C
C------------------------------------------------------
C
C     Problem:    COPPER
C
C     Date:       1.4.2005
C
C------------------------------------------------------
C
*     REAL CONSTANT
      AR   = 3240.0
      V    = 888.0
      Q    = 12000.0
      tau  = 0.083
      m    = 0.33875                
      sc12 = 1.0E+8
      sc34 = 1.0E+4
C            
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (k1,k2,k3,k4,x0)
C     2. variables identifying solution of ordinary
C        differential equations 
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1s, k2s, k3s, k4s, X0, I0
      X, BX0, BX1, BX2, BX3, BX4, BX5, BX6, BX7, BX8, BX9, BX10, BX11,
     /  BX12, BX13, BX14, BX15, BX16, BX17, BX18, BX19, BX20, BX21,
     /  BX22, BX23, BX24
      I, t
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C                  
*     FUNCTION X_t 
      k1 = k1s*sc12
      k2 = k2s*sc12
      k3 = k3s*sc34
      k4 = k4s*sc34
      X_t = k2*BX0**2 - k1*I*X**2
C
*     FUNCTION BX0_t
      BX0_t = k1*I*X**2 + k4*BX1 - k2*BX0**2 - k3*I*BX0
C    
*     FUNCTION BX1_t
      BX1_t = k3*I*BX0 + k4*BX2  - k4*BX1 - k3*I*BX1
C
*     FUNCTION BX2_t
      BX2_t = k3*I*BX1 + k4*BX3 - k4*BX2 - k3*I*BX2
C
*     FUNCTION BX3_t
      BX3_t = k3*I*BX2 + k4*BX4 - k4*BX3 - k3*I*BX3
C
*     FUNCTION BX4_t
      BX4_t = k3*I*BX3 + k4*BX5 - k4*BX4 - k3*I*BX4
C
*     FUNCTION BX5_t
      BX5_t = k3*I*BX4 + k4*BX6 - k4*BX5 - k3*I*BX5
C
*     FUNCTION BX6_t
      BX6_t = k3*I*BX5 + k4*BX7 - k4*BX6 - k3*I*BX6
C
*     FUNCTION BX7_t
      BX7_t = k3*I*BX6 + k4*BX8 - k4*BX7 - k3*I*BX7
C
*     FUNCTION BX8_t
      BX8_t = k3*I*BX7 + k4*BX9 - k4*BX8 - k3*I*BX8
C
*     FUNCTION BX9_t
      BX9_t = k3*I*BX8 + k4*BX10 - k4*BX9 - k3*I*BX9
C
*     FUNCTION BX10_t
      BX10_t = k3*I*BX9 + k4*BX11 - k4*BX10 - k3*I*BX10
C
*     FUNCTION BA11_t
      BX11_t = k3*I*BX10 + k4*BX12 - k4*BX11 - k3*I*BX11
C
*     FUNCTION BX12_t
      BX12_t = k3*I*BX11 + k4*BX13 - k4*BX12 - k3*I*BX12
C
*     FUNCTION BX13_t
      BX13_t = k3*I*BX12 + k4*BX14 - k4*BX13 - k3*I*BX13
C
*     FUNCTION BX14_t
      BX14_t = k3*I*BX13 + k4*BX15 - k4*BX14 - k3*I*BX14
C
*     FUNCTION BX15_t
      BX15_t = k3*I*BX14 + k4*BX16 - k4*BX15 - k3*I*BX15
C
*     FUNCTION BX16_t
      BX16_t = k3*I*BX15 + k4*BX17 - k4*BX16 - k3*I*BX16
C
*     FUNCTION BX17_t
      BX17_t = k3*I*BX16 + k4*BX18 - k4*BX17 - k3*I*BX17 
C
*     FUNCTION BX18_t
      BX18_t = k3*I*BX17 + k4*BX19 - k4*BX18 - k3*I*BX18
C
*     FUNCTION BX19_t
      BX19_t = k3*I*BX18 + k4*BX20 - k4*BX19 - k3*I*BX19
C
*     FUNCTION BX20_t
      BX20_t = k3*I*BX19 + k4*BX21 - k4*BX20 - k3*I*BX20
C
*     FUNCTION BX21_t
      BX21_t = k3*I*BX20 + k4*BX22 - k4*BX21 - k3*I*BX21
C
*     FUNCTION BX22_t
      BX22_t = k3*I*BX21 + k4*BX23 - k4*BX22 - k3*I*BX22
C
*     FUNCTION BX23_t
      BX23_t = k3*I*BX22 + k4*BX24 - k4*BX23 - k3*I*BX23
C
*     FUNCTION BX24_t
      BX24_t = k3*I*BX23 - k4*BX24
C       
*     FUNCTION I_t
      I_t = -I + AR*m*(0.5*k2*BX0**2 + k4*BX1 + k4*BX2 + 
     /      k4*BX3 + k4*BX4 + k4*BX5 + k4*BX6 + k4*BX7 +
     /      k4*BX8 + k4*BX9 + k4*BX10 + k4*BX11 + k4*BX12 +
     /      k4*BX13 + k4*BX14 + k4*BX15 + k4*BX16 + k4*BX17 +
     /      k4*BX18 + k4*BX19 + k4*BX20 + k4*BX21 + k4*BX22 +
     /      k4*BX23 + k4*BX24 -  
     /      0.5*k1*I*X**2 - k3*I*BX0 - k3*I*BX1 - 
     /      k3*I*BX2 - k3*I*BX3 - k3*I*BX4 - k3*I*BX5 -
     /      k3*I*BX6 - k3*I*BX7 - k3*I*BX8 - k3*I*BX9 -
     /      k3*I*BX10 - k3*I*BX11 - k3*I*BX12 - k3*I*BX13 -
     /      k3*I*BX14 - k3*I*BX15 - k3*I*BX16 - 
     /      k3*I*BX17 - k3*I*BX18- k3*I*BX19 - 
     /      k3*I*BX20 - k3*I*BX21 - k3*I*BX22 - k3*I*BX23)/V 
     
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      k1 = k1s*sc12
      k2 = k2s*sc12
      k3 = k3s*sc34
      k4 = k4s*sc34
      X_0=X0
C
*     FUNCTION BX0_0
      a = X0*(k1/k2)**0.5
      BX0_0 = a
C
*     FUNCTION BX1_0
      b = k3/k4*a
      BX1_0 = b
C
*     FUNCTION BX2_0
      c = k3/k4*b
      BX2_0 = c
C
*     FUNCTION BX3_0
      d = k3/k4*c
      BX3_0 = d
C
*     FUNCTION BX4_0
      e = k3/k4*d
      BX4_0 = e
C
*     FUNCTION BX5_0
      f = k3/k4*e
      BX5_0 = f
C
*     FUNCTION BX6_0
      g = k3/k4*f
      BX6_0 = g
C
*     FUNCTION BX7_0
      h = k3/k4*g
      BX7_0 = h
C
*     FUNCTION BX8_0
      n = k3/k4*h
      BX8_0 = n
C
*     FUNCTION BX9_0
      j = k3/k4*n
      BX9_0 = j
C
*     FUNCTION BX10_0
      k = k3/k4*j
      BX10_0 = k
C
*     FUNCTION BX11_0
      l = k3/k4*k
      BX10_0 = l
C
*     FUNCTION BX12_0
      m1 = k3/k4*l
      BX11_0 = m1
C
*     FUNCTION BX13_0
      m2 = k3/k4*m1
      BX13_0 = m2
C
*     FUNCTION BX14_0
      m3 = k3/k4*m2
      BX14_0 = m3
C
*     FUNCTION BX15_0
      m4 = k3/k4*m3
      BX15_0 = m4
C
*     FUNCTION BX16_0
      m5 = k3/k4*m4
      BX16_0 = m5
C
*     FUNCTION BX17_0
      m6 = k3/k4*m5
      BX17_0 = m6
C
*     FUNCTION BX18_0
      m7 = k3/k4*m6
      BX18_0 = m7
C
*     FUNCTION BX19_0
      m8 = k3/k4*m7
      BX19_0 = m8
C
*     FUNCTION BX20_0
      m9 = k3/k4*m8
      BX20_0 = m9
C
*     FUNCTION BX21_0
      m10 = k3/k4*m9
      BX21_0 = m10
C
*     FUNCTION BX22_0
      m11 = k3/k4*m10
      BX22_0 = m11
C
*     FUNCTION BX23_0
      m12 = k3/k4*m11
      BX23_0 = m12
C
*     FUNCTION BX24_0
      m13 = k3/k4*m12
      BX24_0 = m13     
C
*     FUNCTION I_0
      I_0 = I0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION I_fit
      I_fit = I
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g
C      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
