C
C------------------------------------------------------
C
C     Problem:   COOL_CRI
C
C     Datum:     4.11.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      mh2o = 1659.8
      rhos = 2.11
      kv = 1
      ka = 6
      ls = 0.2
      g = 1.32
      b = 1.78
C
C------------------------------------------------------
C
*     SPLINE Te
       0.0        32.0400
       0.35000    32.0190
       0.60000    31.9953
       0.85000    31.9637
       1.10000    31.9506
       1.35000    31.9414
       1.60000    31.9260
       1.85000    31.8852
       2.10000    31.8656
       2.35000    31.8369
       2.60000    31.8019
       2.85000    31.7623
       3.10000    31.7136
       3.35000    31.7005
       3.60000    31.6404
       3.85000    31.5773
       4.10000    31.5241
       4.35000    31.4449
       4.60000    31.3954
       4.85000    31.3398
       5.10000    31.3008
       5.35000    31.2586
       5.60000    31.1780
       5.85000    31.1276
       6.10000    31.0773
       6.35000    31.0301
       6.60000    30.9881
       6.85000    30.9437
       7.10000    30.8976
       7.35000    30.8383
       7.60000    30.7878
       7.85000    30.7615
       8.10000    30.7040
       8.35000    30.6878
       8.60000    30.6675
       8.85000    30.6382
       9.10000    30.6178
       9.35000    30.6274
       9.60000    30.6102
       9.85000    30.5981
       10.1000    30.5777
       10.3500    30.5904
       10.6000    30.6143
       10.8500    30.6010
       11.1000    30.6157
       11.3500    30.6170
       11.6000    30.6179
       11.8500    30.6035
       12.1000    30.6085
       12.3500    30.6059
       12.6000    30.5831
       12.8500    30.5672
       13.1000    30.5770
       13.3500    30.5749
       13.6000    30.5315
       13.8500    30.5220
       14.1000    30.4944
       14.3500    30.4751
       14.6000    30.4826
       14.8500    30.4428
       15.1000    30.4300
       15.3500    30.4450
       15.6000    30.3955
       15.8500    30.3818
       16.1000    30.3663
       16.3500    30.3494
       16.6000    30.3136
       16.8500    30.2975
       17.1000    30.2863
       17.3500    30.2484
       17.6000    30.2519
       17.8500    30.2543
       18.1000    30.2410
       18.3500    30.2227
       18.6000    30.2039
       18.8500    30.1907
       19.1000    30.1725
       19.3500    30.1538
       19.6000    30.1256
       19.8500    30.1149
       20.1000    30.0775
       20.3500    30.0572
       20.6000    30.0521
       20.8500    30.0394
       21.1000    30.0156
       21.3500    29.9989  
       21.6000    29.9872
       21.8500    29.9731
       22.1000    29.9632
       22.3500    29.9472
       22.6000    29.9360
       22.8500    29.9522
       23.1000    29.9126
       23.3500    29.8998
       23.6000    29.8759
       23.8500    29.8591
       24.1000    29.8534
       24.3500    29.8434
       24.6000    29.8363
       24.8500    29.8314
       25.1000    29.8130
       25.3500    29.8061
       25.6000    29.7953
       25.8500    29.7577
       26.1000    29.7464
       26.3500    29.7445
       26.6000    29.7281
       26.8500    29.7167
       27.1000    29.7027
       27.3500    29.6719
       27.6000    29.6863
       27.8500    29.6664
       28.1000    29.6615
       28.3500    29.6640
       28.6030    29.6718
       28.8530    29.6563
       29.1030    29.6394
       29.3530    29.6126
       29.6030    29.5788
       29.8530    29.5852
       30.1030    29.5806
       30.3530    29.5714
       30.6030    29.5650
       30.8530    29.5905
       31.1030    29.5784
       31.3530    29.5548
       31.6030    29.5444
       31.8530    29.5461
       32.1030    29.5383
       32.3530    29.5268
       32.6030    29.5187
       32.8530    29.5041
       33.1030    29.4939
       33.3530    29.4867
       33.6030    29.4757
       33.8530    29.4740
       34.1050    29.4668
       34.3550    29.4558
       34.6050    29.4540
       34.8550    29.4468
       35.1050    29.4328
       35.3550    29.4169
       35.6050    29.3909
       35.8550    29.3936
       36.1050    29.3535
       36.3550    29.3675
       36.6050    29.3712
       36.8550    29.3649
       37.1050    29.3604
       37.3550    29.3513
       37.6050    29.3509
       37.8550    29.3506
       38.1050    29.3444
       38.3550    29.3401
       38.6050    29.3281
       38.8550    29.3197
       39.1050    29.3438
       39.3550    29.3186
       39.6050    29.3070
       39.8550    29.2779
       40.1050    29.2786
       40.3550    29.2640
       40.6050    29.2688
       40.8550    29.2722
       41.1050    29.2595
       41.3550    29.2357
       41.6050    29.2190
       41.8550    29.2073
       42.1050    29.2141
       42.3550    29.2189
       42.6050    29.1772
       42.8550    29.1930
       43.1050    29.1891
       43.3550    29.2014
       43.6050    29.2100
       43.8550    29.2010
       44.1050    29.2187
       44.3550    29.2311
       44.6070    29.2308
       44.8570    29.2245
       45.1070    29.2112
       45.3570    29.2018
       45.6070    29.2043
       45.8570    29.1670
       46.1070    29.1709
       46.3570    29.1826
       46.6070    29.1818
       46.8570    29.1813
       47.1070    29.1809
       47.3570    29.1806
       47.6070    29.1654
       47.8570    29.1548
       48.1070    29.1564
       48.3570    29.1575
       48.6070    29.1732
       48.8570    29.1753
       49.1070    29.1557
       49.3570    29.1570
       49.6070    29.1429
       49.8570    29.1390
       50.1070    29.1213
       50.3570    29.1239
       50.6070    29.1257
       50.8570    29.1360
       51.1070    29.1582
       51.3570    29.1648
       51.6070    29.1543
       51.8570    29.1320
       52.1070    29.1314
       52.3570    29.1310
       52.6070    29.1457
       52.8570    29.1710
       53.1070    29.1527
       53.3570    29.1609
       53.6070    29.1006
       53.8570    29.1094
       54.1070    29.1006
       54.3570    29.1094
       54.6070    29.1096
       54.8570    29.1097
       55.1070    29.1098
       55.3570    29.1009
       55.6070    29.0886
       55.8570    29.0860
       56.1070    29.0632
       56.3570    29.0683
       56.6070    29.0658
       56.8570    29.0700
       57.1070    29.0670
       57.3600    29.1159
       57.6100    29.1051
       57.8600    29.0856
       58.1100    29.0989
       58.3600    29.0872
       58.6100    29.0791
       58.8600    29.0674
       59.1100    29.0651
       59.3600    29.0846
       59.6100    29.0412
       59.8600    29.0469
       60.1100    29.0508
       60.3600    29.0476
       60.6100    29.0453
       60.8600    29.0437
       61.1100    29.0336
       61.3600    29.0355
       61.6100    29.0369
       61.8600    29.0378
       62.1100    29.0295
       62.3600    29.0386
       62.6100    29.0300
       62.8600    29.0330
       63.1100    29.0261
       63.3600    29.0153
       63.6100    29.0137
       63.8600    29.0126
       64.1100    29.0118
       64.3600    29.0203
       64.6100    29.0262
       64.8600    28.9913
       65.1100    28.9909
       65.3600    28.9967
       65.6100    29.0097
       65.8600    28.9888
       66.1100    28.9951
       66.3600    29.0146
       66.6100    29.0132
       66.8600    29.0063
       67.1100    28.9864
       67.3600    28.9725
       67.6100    28.9777
       67.8600    28.9964
       68.1100    28.9645
       68.3600    28.9721
       68.6100    28.9835
       68.8600    28.9914
       69.1100    28.9970
       69.3600    28.9799
       69.6100    28.9739
       69.8600    28.9638
       70.1100    28.9716
       70.3600    28.9681
       70.6100    28.9657
       70.8600    28.9640
       71.1100    28.9568
       71.3600    28.9428
       71.6100    28.9479
       71.8600    28.9605
       72.1100    28.9694
       72.3600    28.9756
       72.6100    28.9409
       72.8600    28.9466
       73.1100    28.9506
       73.3600    28.9534
       73.6100    28.9854
       73.8600    28.9868
       74.1100    28.9788
       74.3600    28.9671
       74.6100    28.9590
       74.8600    28.9593
       75.1100    28.9595
       75.3600    28.9387
       75.6100    28.9391
       75.8600    28.9243
       76.1100    28.9350
       76.3600    28.9365
       76.6100    28.9526
       76.8600    28.9698
       77.1100    28.9819
       77.3600    28.9693
       77.6100    28.9605
       77.8600    28.9544
       78.1100    28.9501
       78.3600    28.9110
       78.6100    28.9197
       78.8600    28.8958
       79.1100    28.9091
       79.3600    28.9033
       79.6100    28.8993
       79.8600    28.9175
       80.1100    28.9153
       80.3600    28.9227
       80.6100    28.9189
       80.8600    28.9252
       81.1100    28.9297
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      kg, lnkb, m, mue0a, mue1a, mue2a, mue3a,  t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dm_t
      cs = 0.1286 + 5.88E-3*Te(t) + 1.721E-4*Te(t)**2
      S = (m/mh2o - cs)/ cs
      IF (S.GT.0) THEN
        xG = kg*S**g
      ELSE
        xG = 0
      ENDIF
      dm_t = -3*kv*rhos*xG*mue2a
C
*     FUNCTION dmue0a_t
      IF (S.GT.0) THEN
        xB = EXP(lnkb)*mue3a*S**b         
      ELSE
        xB = 0
      ENDIF
      dmue0a_t = xB
C
*     FUNCTION dmue1a_t
      IF (S.GT.0) THEN
        xG = kg*S**g
      ELSE
        xG = 0
      ENDIF
      dmue1a_t = xG*mue0a 
C
*     FUNCTION dmue2a_t
      IF (S.GT.0) THEN
        xG = kg*S**g
      ELSE
        xG = 0
      ENDIF
      dmue2a_t = 2*xG*mue1a
C
*     FUNCTION dmue3a_t
      IF (S.GT.0) THEN
        xG = kg*S**g
      ELSE
        xG = 0
      ENDIF
      dmue3a_t = 3*xG*mue2a
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION m0
      m0 = 0.4922*mh2o
C
*     FUNCTION mue0a0
      mue0a0 = 0.811*mh2o
C
*     FUNCTION mue1a0
      mue1a0 = 1.59E-2*mh2o
C
*     FUNCTION mue2a0
      mue2a0 = 3.11E-4*mh2o
C
*     FUNCTION mue3a0
      mue3a0 = 6.1E-6*mh2o
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT1
      FIT1 = m/mh2o
c
*     FUNCTION FIT2
      X = m/mh2o
      rho28 = 0.4214*X + 1.0236
      rho32 = 0.5433*X + 0.9667
      rhof  = (rho32 - rho28)/4.0*(Te(t) - 28) + rho28
      Vges  = (m + mh2o)/rhof + kv*mue3a
      convert = mh2o/Vges
      FIT2 = EXP(-ka/2*ls*convert*mue2a/mh2o)
C
*     FUNCTION FIT3
      FIT3 = Te(t)
C
*     FUNCTION FIT4   
      cs = 0.1286 + 5.88E-3*Te(t) + 1.721E-4*Te(t)**2
      S = (m/mh2o - cs)/ cs
      FIT4 = S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
