C
C------------------------------------------------------
C
C     Problem:    COOL
C
C     Date:       23.01.2001
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      C0 = 6E-4  
      T0 = 302   
      CP = 1.35E-4   
      RHO = 1
      HR = -35   
      R = 1.98E-3
      Z = 2000   
      E = 10.1   
      A = 900
      U = 4E-6   
      RHOC = 1   
      CPC = 1E-3 
      FC = 2000
      VC = 100000
      TC0 = 298  
      T10=300
      T20=310
      T30=340  
      C10=6.0E-04
      C20=6.0E-04
      C30=6.0E-04
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Fs, Vs, C1, C2, C3, T1, T2, T3, TC1, TC2, TC3, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION C1P
      F = Fs*1E3
      V = Vs*1E5
      K1 = Z*EXP(-E/(R*T1))   
      C1P = F*(C0-C1)/V-K1*C1 
C
*     FUNCTION C2P
      K2 = Z*EXP(-E/(R*T2))   
      C2P = F*(C1-C2)/V-K2*C2 
C
*     FUNCTION C3P
      K3 = Z*EXP(-E/(R*T3))   
      C3P = F*(C2-C3)/V-K3*C3 
C
*     FUNCTION T1P
      H1 = F*(T0-T1)/V-(K1*C1*HR)/(RHO*CP)
      T1P = H1-U*A*(T1-TC3)/(RHO*CP*V)
C
*     FUNCTION T2P
      H2 = F*(T1-T2)/V-(K2*C2*HR)/(RHO*CP)
      T2P = H2-U*A*(T2-TC2)/(RHO*CP*V)
C
*     FUNCTION T3P
      H3 = F*(T2-T3)/V-(K3*C3*HR)/(RHO*CP)
      T3P = H3-U*A*(T3-TC1)/(RHO*CP*V)
C
*     FUNCTION TC1P
      TC1P = FC*(TC0-TC1)/VC+U*A*(T3-TC1)/(RHOC*CPC*VC)   
C
*     FUNCTION TC2P
      TC2P = FC*(TC1-TC2)/VC+U*A*(T2-TC2)/(RHOC*CPC*VC)   
C
*     FUNCTION TC3P
      TC3P = FC*(TC2-TC3)/VC+U*A*(T1-TC3)/(RHOC*CPC*VC)   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION C1_0
      C1_0=C10  
C
*     FUNCTION C2_0
      C2_0=C20  
C
*     FUNCTION C3_0
      C3_0=C30  
C
*     FUNCTION T1_0
      T1_0=T10  
C
*     FUNCTION T2_0
      T2_0=T20  
C
*     FUNCTION T3_0
      T3_0=T30  
C
*     FUNCTION TC1_0
      TC1_0 = TC0   
C
*     FUNCTION TC2_0
      TC2_0 = TC0   
C
*     FUNCTION TC3_0
      TC3_0 = TC0   
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X1
      X1 = (C0-C1)/C0
C
*     FUNCTION X2
      X2 = (C0-C2)/C0
C
*     FUNCTION X3
      X3 = (C0-C3)/C0
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
