C
C------------------------------------------------------
C
C     Problem:    CON_BURG
C
C     Date:       27.11.97
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..9
C
C------------------------------------------------------
C
*     REAl CONSTANT
      eps = 0.4
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      y20, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_p
      y1_p = y2
C
*     FUNCTION y2_p
      y2_p = y1*y2/eps
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 2*tanh(1/eps)
C
*     FUNCTION y2_0
      y2_0 = y20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION y1_bnd
      y1_bnd = y1
C
*     FUNCTION y1_gt_0(i), i in ind
      y1_gt_0(i) = y1
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


