C
C------------------------------------------------------
C
C     Problem:    CONVER
C
C     Date:       30.12.2002
C
C------------------------------------------------------
C      
*     REAL CONSTANT
      R = 0.008314
      f = 0.5
      Ad = 2.6E16
      Ap = 1.051E7
      At = 1.255E9
      Ed = 134.161
      Ep = 29.553
      Et = 7.0235
      Mw = 104.14    
c      Q = 150  
      deltaH = 57766.8
      A = 0.0533     
      Vol = 2
      alpha = 0.4
      v = 1
      M0 = 6.699  
      U0 = 6.699   
      Tci = 294.15   
      rho = 983.73
      Cp = 199.13
      T0 = 373       
      Mc = 0.023
      Cpc = 77.2  
      Vc = 2
      rhoc = 998
      Tc00 = 367.15
C
C------------------------------------------------------
C      
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      I0, a0, a1, a2, a3, a4
      I, M, q0, q2, T, Tc0, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION I_t
      kd = Ad*EXP(-Ed/(R*T))
      kp = Ap*EXP(-Ep/(R*T))
      kt = At*EXP(-Et/(R*T)) 
      I_t = -kd*I
C
*     FUNCTION M_t 
      P = SQRT(abs(2*f*kd*I/kt))
      M_t = -kp*P*M
C
*     FUNCTION q0_t    
      q0_t = 2*f*(1 - v/2)*kd*I
C
*     FUNCTION q2_t    
      q2_t = (2 + v)*kp**2/kt*M**2
C
*     FUNCTION T_t    
      Rm = kp*P*M       
      X = (M0 - M)/M0         
      U = U0 - alpha*X                     
      Tc = (Tci + Tc0)/2  
      Q = a0 + a1*time + a2*time**2 + a3*time**3 + a4*time**4
      T_t = (Q - deltaH*Rm*Vol - U*A*(T - Tc))/(Vol*rho*Cp/Mw) 
C
*     FUNCTION Tc0_t    
      Tc0_t = (Mc*Cpc*(Tci - Tc0) + U*A*(T - Tc))/(Vc*rhoc*Cpc/18) 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION I_0
      I_0 = I0
C
*     FUNCTION M_0
      M_0 = M0
C
*     FUNCTION q0_0
      q0_0 = 0
C
*     FUNCTION q2_0
      q2_0 = 0
C
*     FUNCTION T_0
      T_0 = T0
C
*     FUNCTION Tc0_0
      Tc0_0 = Tc00
C
C------------------------------------------------------
C
C   - Fitting criteria:
C   
*     FUNCTION I_plot
      I_plot = I
C
*     FUNCTION M_plot
      M_plot = M
C
*     FUNCTION q0_plot
      q0_plot = q0
C
*     FUNCTION q2_plot
      q2_plot = q2
C
*     FUNCTION T_plot
      T_plot = T
C
*     FUNCTION Tc0_plot        
      Tc0_plot = Tc0           
C      
*     FUNCTION X_fit
      X = (M0 - M)/M0         
      X_fit = X
C   
*     FUNCTION Xn_fit 
      IF (q0.gt.0) then
         Xn = (M0 - M)/q0         
      ELSE
         Xn = 1
      ENDIF      
      Xn_fit = Xn 
C      
*     FUNCTION Q_fit
      Q = a0 + a1*time + a2*time**2 + a3*time**3 + a4*time**4       
      Q_fit = Q
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
