C
C------------------------------------------------------
C
C     Problem:    CONTUN
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      M=50          
      W0=250        
      T0=20         
      Lambda=537     
      Ws0=0.2        
      Ki=10         
      TRset=40     
      TAUc=0.1     
      TAUw=0.3       
      TAUi=10000
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time v ariable (t)
C
*     VARIABLE
      Cp, Kc, TR, TC, TW, INTG, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION TRP
      W=W0
      IF (T.GE.10) THEN
        W=6*W0
      ENDIF
      IF (T.GE.20) THEN 
        W=W0
      ENDIF
      EPS=TRset-TC
      EPS0=TRset-T0
      Ws=Ws0+Kc*EPS+(Kc/TAUi)*INTG
      IF (Ws.LE.0) THEN
        Ws=0
      ENDIF
      IF (Ws.GE.30) THEN
        Ws=30
      ENDIF
      TRP=W/M*(T0-TR)+Ws*Lambda/(M*Cp)
C
*     FUNCTION TCP
      TCP=(TW-TC)/TAUc
C
*     FUNCTION TWP
      TWP=(TR-TW)/TAUw 
C
*     FUNCTION INTGP
      IF (T.GT.EPS0) THEN
        INTGP=EPS-EPS0
      ELSE
        INFTGP=0
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION TR_0
      IF (T.LT.0.1) THEN
        TR_0=T0
      ELSE
        TR_0=TR
      ENDIF
C
*     FUNCTION TC_0
      IF (T.LT.0.1) THEN
        TC_0=T0
      ELSE
        TC_0=TC
      ENDIF
C
*     FUNCTION TW_0
      IF (T.LT.0.1) THEN
        TW_0=T0
      ELSE
        TW_0=TW
      ENDIF
C
*     FUNCTION INTG_0
      IF (T.LT.0.1) THEN
        INTG_0=0
      ELSE
        INTG_0=INTG
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION TR_fit
      TR_fit=TR
C
*     FUNCTION TC_fit
      TC_fit=TC
C
*     FUNCTION TW_fit
      TW_fit=TW  
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
