C
C------------------------------------------------------
C
C     Problem:    CONTCON
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      KS=0.12
      Y=0.5
      V=1 
      F0=0.4
      KP=2.0
      TI=1.5   
      S0=0.01
      X0=0.1
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      SFEED, UM, KI, X, S, INTG, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      IF (T.LT.3) THEN
        SSET=0.5
      ELSE
        IF (T.LT.6) THEN
          SSET=1
        ELSE
          SSET=2
        ENDIF
      ENDIF
      S1=S
      IF (S.LT.0.0) THEN
        S1=0
      ENDIF
      SMAX=(KS*KI)**0.5   
      UMAX=UM/((2*KS/KI)**0.5+1)
      U=UM*S1/(KS+S1+(S1*S1/KI))  
      E=SSET-S1
      F=F0+KP*E+(KP/TI)*INTG
      IF (F.LT.0.0) THEN
        F=0
      ENDIF 
      XP=U*X-(F/V)*X  
C
*     FUNCTION SP
      SP=(F/V)*(SFEED-S1)-U*X/Y   
C
*     FUNCTION INTGP
      INTGP=E
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      IF (T.LT.1) THEN
        X_0=X0
      ELSE
        X_0=X
      ENDIF
C
*     FUNCTION S_0
      IF (T.LT.1) THEN
        S_0=S0
      ELSE
        S_0=S
      ENDIF
C
*     FUNCTION INTG_0
      IF (T.LT.1) THEN
        INTG_0=0
      ELSE
        INTG_0=INTG
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit=X
C
*     FUNCTION S_fit
      S_fit=S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
