C
C------------------------------------------------------
C
C     Problem:    CONTAMIN
C
C     Date:       03.03.1996
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..4
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Va = 5.05E-3
C
C------------------------------------------------------
C
*     TABLE C0(i), i in ind
      1  0.5
      2  1.0
      3  2.0
      4  5.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      D, Vert, Fa
      u(i), i in ind
      u_x(i), i in ind
      u_xx(i), i in ind
      y(i), i in ind
      x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t(i), i in ind
      u_t(i) = D*u_xx(i)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0(i), i in ind
      u_0(i) = C0(i)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION y_t(i), i in ind
      y_t(i) = -D*Fa*u_x(i)
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION y_0(i), i in ind
      y_0(i) = C0(i)*Va/Vert
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_left(i), i in ind
      u_left(i) = 0
C
*     FUNCTION u_right(i), i in ind
      u_right(i) = Vert*y(i)/Va
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C*     FUNCTION UXL
C      UXL = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind
      fit(i) = y(i)/Va
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
