C
C------------------------------------------------------
C
C     Problem:    CONSTILL
C
C     Date:       13.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      F=1000                 
      Q=1                 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      X, A, MD, MR, M, V1
      X0, X1, X2, X3, X4, X5, X6, X7, X8, X9, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X0P
      R=2.25   
      IF (T.GE.4) THEN
        R=1
      ENDIF
      V=V1+(1-Q)*F
      D=V/(R+1)   
      L=R*D   
      L1=F+Q*F
      W=L1-V1 
      Y1=A*X1/(1+(A-1)*X1)
      Y2=A*X2/(1+(A-1)*X2)
      Y3=A*X3/(1+(A-1)*X3)
      Y4=A*X4/(1+(A-1)*X4)
      Y5=A*X5/(1+(A-1)*X5)
      Y6=A*X6/(1+(A-1)*X6)
      Y7=A*X7/(1+(A-1)*X7)
      Y8=A*X8/(1+(A-1)*X8)
      Y9=A*X9/(1+(A-1)*X9)
      X0P=(V*Y1-(L+D)*X0)/MD  
C
*     FUNCTION X1P
      X1P=(L*(X0-X1)+V*(Y2-Y1))/M 
C
*     FUNCTION X2P
      X2P=(L*(X1-X2)+V*(Y3-Y2))/M 
C
*     FUNCTION X3P
      X3P=(L*(X2-X3)+V*(Y4-Y3))/M 
C
*     FUNCTION X4P
      X4P=(L*(X3-X4)+V*(Y5-Y4))/M 
C
*     FUNCTION X5P
      X5P=(F*X+L*X4-L1*X5+V1*Y6-V*Y5)/M   
C
*     FUNCTION X6P
      X6P=(L1*(X5-X6)+V1*(Y7-Y6))/M   
C
*     FUNCTION X7P
      X7P=(L1*(X6-X7)+V1*(Y8-Y7))/M   
C
*     FUNCTION X8P
      X8P=(L1*(X7-X8)+V1*(Y9-Y8))/M   
C
*     FUNCTION X9P
      X9P=(L1*X8-V1*Y9-W*X9)/MR  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0_0
      IF (T.LT.0.1) THEN
        X0_0=0
      ELSE
        X0_0=X0
      ENDIF
C
*     FUNCTION X1_0
      IF (T.LT.0.1) THEN
        X1_0=0
      ELSE
        X1_0=X1
      ENDIF
C
*     FUNCTION X2_0
      IF (T.LT.0.1) THEN
        X2_0=0
      ELSE
        X2_0=X2
      ENDIF
C
*     FUNCTION X3_0
      IF (T.LT.0.1) THEN
        X3_0=0
      ELSE
        X3_0=X3
      ENDIF
C
*     FUNCTION X4_0
      IF (T.LT.0.1) THEN
        X4_0=0
      ELSE
        X4_0=X4
      ENDIF
C
*     FUNCTION X5_0
      IF (T.LT.0.1) THEN
        X5_0=0
      ELSE
        X5_0=X5
      ENDIF
C
*     FUNCTION X6_0
      IF (T.LT.0.1) THEN
        X6_0=0
      ELSE
        X6_0=X6
      ENDIF
C
*     FUNCTION X7_0
      IF (T.LT.0.1) THEN
        X7_0=0
      ELSE
        X7_0=X7
      ENDIF
C
*     FUNCTION X8_0
      IF (T.LT.0.1) THEN
        X8_0=0
      ELSE
        X8_0=X8
      ENDIF
C
*     FUNCTION X9_0
      IF (T.LT.0.1) THEN
        X9_0=0
      ELSE
        X9_0=X9
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X0_fit
      X0_fit=X0
C
*     FUNCTION X1_fit
      X1_fit=X1
C
*     FUNCTION X2_fit
      X2_fit=X2
C
*     FUNCTION X3_fit
      X3_fit=X3
C
*     FUNCTION X4_fit
      X4_fit=X4
C
*     FUNCTION X5_fit
      X5_fit=X5
C
*     FUNCTION X6_fit
      X6_fit=X6
C
*     FUNCTION X7_fit
      X7_fit=X7
C
*     FUNCTION X8_fit
      X8_fit=X8
C
*     FUNCTION X9_fit
      X9_fit=X9
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

