C
C------------------------------------------------------
C
C     Problem:    CONSREA
C
C     Date:       07.07.2003
C
C------------------------------------------------------
C                     
*     REAL CONSTANT
      lambda11 = 1
      lambda12 = 1
      lambda21 = 2
      lambda22 = 1
      lambda31 = 1
      lambda32 = 2
      lambda41 = 2
      lambda42 = 2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      theta1, theta2
      A1, B1, C1
      A2, B2, C2
      A3, B3, C3
      A4, B4, C4
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION A1_t
      IF (A1.GT.0) THEN
        A1_t = -theta1*A1**lambda11
      ELSE
        A1_t = 0
      ENDIF     
C
*     FUNCTION B1_t     
      IF ((A1.GT.0).AND.(B1.GT.0)) THEN
        B1_t = theta1*A1**lambda11 - theta2*B1**lambda12       
      ELSE
        B1_t = 0
      ENDIF    
C
*     FUNCTION C1_t
      IF (B1.GT.0) THEN
        C1_t = theta2*B1**lambda12
      ELSE
        C1_t = 0
      ENDIF    
C
*     FUNCTION A2_t
      IF (A2.GT.0) THEN
        A2_t = -theta1*A2**lambda21
      ELSE
        A2_t = 0
      ENDIF     
C
*     FUNCTION B2_t   
      IF ((A2.GT.0).AND.(B2.GT.0)) THEN
        B2_t = theta1*A2**lambda21 - theta2*B2**lambda22
      ELSE
        B2_t = 0
      ENDIF    
C
*     FUNCTION C2_t
      IF (B2.GT.0) THEN
        C2_t = theta2*B2**lambda22
      ELSE
        C2_t = 0
      ENDIF    
C      
*     FUNCTION A3_t
      IF (A3.GT.0) THEN
        A3_t = -theta1*A3**lambda31
      ELSE
        A3_t = 0
      ENDIF     
C
*     FUNCTION B3_t   
      IF ((A3.GT.0).AND.(B3.GT.0)) THEN
        B3_t = theta1*A3**lambda31 - theta2*B3**lambda32
      ELSE
        B3_t = 0
      ENDIF    
C
*     FUNCTION C3_t
      IF (B3.GT.0) THEN
        C3_t = theta2*B3**lambda32
      ELSE
        C3_t = 0
      ENDIF    
C
*     FUNCTION A4_t
      IF (A4.GT.0) THEN
        A4_t = -theta1*A4**lambda41
      ELSE
        A4_t = 0
      ENDIF     
C
*     FUNCTION B4_t   
      IF ((A4.GT.0).AND.(B4.GT.0)) THEN
        B4_t = theta1*A4**lambda41 - theta2*B4**lambda42
      ELSE
        B4_t = 0
      ENDIF    
C
*     FUNCTION C4_t
      IF (B4.GT.0) THEN
        C4_t = theta2*B4**lambda42
      ELSE
        C4_t = 0
      ENDIF    
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION A1_0
      A1_0 = 1
C
*     FUNCTION B1_0
      B1_0 = 0.00001
C
*     FUNCTION C1_0
      C1_0 = 0.00001
C
*     FUNCTION A2_0
      A2_0 = 1
C
*     FUNCTION B2_0
      B2_0 = 0.00001
C
*     FUNCTION C2_0
      C2_0 = 0.00001
C
*     FUNCTION A3_0
      A3_0 = 1
C
*     FUNCTION B3_0
      B3_0 = 0.00001
C
*     FUNCTION C3_0
      C3_0 = 0.00001
C
*     FUNCTION A4_0
      A4_0 = 1
C
*     FUNCTION B4_0
      B4_0 = 0.00001
C
*     FUNCTION C4_0
      C4_0 = 0.00001
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION B1_fit
      B1_fit = B1
C
*     FUNCTION B2_fit
      B2_fit = B2
C
*     FUNCTION B3_fit
      B3_fit = B3
C
*     FUNCTION B4_fit
      B4_fit = B4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
