C
C------------------------------------------------------
C
C     Problem:    CONINHIB
C
C     Date:       13.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      KI=2.2   
      Y=0.5
      S0=5
      D=0.25
      XI=1
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      KS, UM, X, S, SI, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      U=UM*S/(KS+S+(S*S/KI))  
      XP=(U-D)*X  
C
*     FUNCTION SP
      SP=D*(S0-S)-U*X/Y   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0=XI
C
*     FUNCTION S_0
      S_0=SI
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION S_fit
      S_fit=S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G=...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
