C
C------------------------------------------------------
C
C     Problem:    CONF_ALT
C
C     Date:       29.9.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L0 = 1000
      k2p = 1.3749E-4
      k1m = 0.47773
      tau1 = 1
      tau2 = 2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1p, k2m, I0, r0, k, y20
      y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_p
      y1_p = k1p*(r0-y1-y2)*(L0-y1) - k1m*y1
C
*     FUNCTION y2_p
      if (t.le.tau1) then
        y2_p = 0
      else
        if (t.le.tau2) then
          y2_p = k2p*(r0-y1-y2)*(I0-y2) - k2m*y2
        else
          y2_p = -k*y2
        endif
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      if (t.lt.tau1) then
        y1_0 = 0
      else
        y1_0 = y1
      endif
C
*     FUNCTION y2_0
      if (t.lt.tau1) then
        y2_0 = 0
      else
        if (t.lt.tau2) then
          y2_0 = y20
        else
          y2_0 = y2
        endif
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
