C
C------------------------------------------------------
C
C     Problem:    CONFLO3
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      A=1
      G=9.81
      Z0=3
      ZMAX=4
      P0=101.325
      P3=101.35  
      RHO=1000 
      GAMMA=1.41
      TG0=330   
C
C------------------------------------------------------
C
*     CONINT P1
      0.0       150.0
      210.0     300.0
      510.0     200.0
      1140.0    150.0
      5000.0    150.0
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      KV1, KV2, Z, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION ZP
      VG0=(ZMAX-Z0)*A
      VG=(ZMAX-Z)*A
      IF (VG.GT.0.0001) THEN
        TG=TG0*(VG0/VG)**(GAMMA-1) 
        PG=P0*VG0*TG/(VG*TG0)  
      ELSE
        PG=P0
      ENDIF
      P2=PG+RHO*G*Z*0.001
      P1T=P1(T)
      IF (P2.GT.P1T) THEN
        P2=P1T
      ENDIF
      F1=KV1*SQRT(P1T-P2)
      IF (P2.GE.P3) THEN
        F2=KV2*SQRT(P2-P3)  
      ELSE
        F2=0
      ENDIF
      ZP =(F1-F2)/A
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Z_0
      IF (T.LT.0.1) THEN
        Z_0=Z0
      ELSE
        Z_0=Z
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION F1_fit
      PG0=P0
      VG0=(ZMAX-Z0)*A
      VG=(ZMAX-Z)*A
      IF (VG.GT.0.001) THEN
        TG=TG0*(VG0/VG)**(GAMMA-1) 
        PG=P0*VG0*TG/(VG*TG0)  
      ELSE
        PG=PG0
      ENDIF
      P2=PG+RHO*G*Z*0.001
      P1T=P1(T)
      IF (P2.GT.P1T) THEN
        P2=P1T
      ENDIF
      F1_fit=KV1*SQRT(P1T-P2)
C
*     FUNCTION F2_fit
      IF (P2.GE.P3) THEN
        F2_fit=KV2*SQRT(P2-P3)  
      ELSE
        F2_fit=0
      ENDIF
C
*     FUNCTION Z_fit
      Z_fit=Z
C
*     FUNCTION VG_fit
      VG_fit=TG
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




