C
C------------------------------------------------------
C
C     Problem:    CONFLO1
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      A=1
      G=9.81
      Z0=3.0
      P0=101.325
      P3=101.35  
      RHO=1000 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      KV1, KV2, Z, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION ZP
      P1=150    
      IF (T.GE.1000) THEN
        P1=200
      ENDIF
      P2=P0+RHO*G*Z/1000 
      IF (P2.GT.P1) THEN
        P2=P1
      ENDIF
      F1=KV1*SQRT(P1-P2)
      F2=KV2*SQRT(P2-P3)  
      ZP =(F1-F2)/A
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Z_0
      IF (T.LT.0.1) THEN
        Z_0=Z0
      ELSE
        Z_0=Z
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION F1_fit
      P1=150    
      IF (T.GE.1000) THEN
        P1=200
      ENDIF
      P2=P0+RHO*G*Z/1000 
      IF (P2.GT.P1) THEN
        P2=P1
      ENDIF
      F1_fit=KV1*SQRT(P1-P2)
C
*     FUNCTION F2_fit
      F2_fit=KV2*SQRT(P2-P3)  
C
*     FUNCTION Z_fit
      Z_fit = Z
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
