C
C------------------------------------------------------
C
C     Problem:    CONDENS
C
C     Date:       27.01.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R = 8.306
      c_p = 46.887
      T_z = 350.0
      T_k = 300.0
      A = 23.47
      B = 3626.55
      C = -34.29
      lambda = 35220
C
C------------------------------------------------------
C
*     CONINT F
      0.0     0.1
      10.0    0.11
      1000.0  0.11
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      V, aA, N, T, p, L, p_t, T_t, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION N_t
      N_t = F(time) - L
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION a1
      a1 = F(time)*c_p*(T_z - T) + lambda*L - aA*(T - T_k) 
     /     - N*c_p*T_t + V*p_t
C
*     FUNCTION a2
      a2 = N*R*T - p*V
C
*     FUNCTION a3
      a3 = exp(A-B/(T+C)) - p
C
*     FUNCTION a4
      a4 = V*p_t - R*T*(F(time) - L) - N*R*T_t
C
*     FUNCTION a5
      a5 = p_t - B/(T+C)**2*T_t*p
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION N0
      IF (time.LT.1) THEN
        N0 = 2.011
      ELSE
        N0 = N
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION T0
      T0 = 337.8
C
*     FUNCTION p0
      p0 = 100570.0
C
*     FUNCTION L0
      L0 = 0.1
C
*     FUNCTION p_t0
      p_t0 = 0.0
C
*     FUNCTION T_t0
      T_t0 = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Nfit
      Nfit = N
C
*     FUNCTION Tfit
      Tfit = T
C
*     FUNCTION pfit
      pfit = p
C
*     FUNCTION Lfit
      Lfit = L
C
*     FUNCTION pfit_t
      pfit_t = p_t
C
*     FUNCTION Tfit_t
      Tfit_t = T_t
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
