C
C------------------------------------------------------
C
C     Problem:    COMP_EXP
C
C     Date:       27.02.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      F = 0.7
      D = 44
      V = 0.06
      ka = 1.7
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k10, k12, k20, k21, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -(k10 + k12)*y1 + k21*y2 + F*D*ka*exp(-ka*t)
C
*     FUNCTION y2_t
      y2_t = k12*y1 - (k20 + k21)*y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 0
C
*     FUNCTION y2_0
      y2_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1/V
C
*     FUNCTION y2_fit
      y2_fit = y2/V
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
