C
C------------------------------------------------------
C
C     Problem:    COMP_ADS
C
C     Date:       10.04.2003
C
C------------------------------------------------------
C                     
*     REAL CONSTANT
      Ar = 3700
      V = 888
      tau = 0.0247
      Cgsat1 = 56
      Cgsat2 = 106.8
      Xtotal= 1E+15
      S = 2.46E+10
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      ka0s, kd0s, ka1s, kd1s, ka2s, kd2s, ka3s, kd3s, kfors, krevs
      X, A, B, C, S1, S2, Cg1, Cg2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X_t        
      ka0 = ka0s*0.0001
      kd0 = kd0s*0.1
      ka1 = ka1s
      kd1 = kd1s*1000
      ka2 = ka2s*0.00001
      kd2 = kd2s
      ka3 = ka3s*0.1
      kd3 = kd3s*1000
      kfor = kfors*10
      krev = krevs*10
      X_t = kd0*tau*A + kd2*tau*B - ka0*tau*Cgsat1*Cg1*X**2 
     /      - ka2*tau*Cgsat2*Cg2*X
C
*     FUNCTION A_t
      A_t = ka0*tau*Cgsat1*Cg1*X**2 - kd0*tau*A     
     /      + krev*tau*S1*C/(1-X) - kfor*tau*S2*A/(1-X)
C
*     FUNCTION B_t
      B_t = ka2*tau*Cgsat2*Cg2*X - kd2*tau*B
C
*     FUNCTION C_t
      C_t = -A_t -B_t -X_t 
C
*     FUNCTION S1_t
      S1_t = ka1*tau*Cgsat1*Cg1*(1-X) - kd1*tau*S1
C
*     FUNCTION S2_t
      S2_t = ka3*tau*Cgsat2*Cg2*(1-X) - kd3*tau*S2
C
*     FUNCTION Cg1_t
      Cg1_t = -Cg1 - (Ar*Xtotal)/(V*Cgsat1)*(0.5*A_t + S1_t)/S
C
*     FUNCTION Cg2_t
      Cg2_t = -Cg2 - (Ar*Xtotal)/(V*Cgsat2)*(B_t + C_t + S2_t)/S
C           
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      ka0 = ka0s*0.0001
      kd0 = kd0s*0.1
      ka1 = ka1s
      kd1 = kd1s*1000
      ka2 = ka2s*0.00001
      kd2 = kd2s
      ka3 = ka3s*0.1
      kd3 = kd3s*1000
      kfor = kfors*10
      krev = krevs*10
      X_0 = ((ka2/kd2*106.8 + 1) - ((ka2/kd2*106.8)**2 + 
     /      2*ka2/kd2*106.8 + 1 + 4*56*ka0/kd0 + 4*kfor/krev*
     /      ka3/kd3*kd1/ka1*1.90714)**0.50) 
     /      /(-(112.0*ka0/kd0 + 2*kfor/krev*ka3/kd3*kd1/ka1*1.9071))
C
*     FUNCTION A_0
      A_0 = 56.0*ka0/kd0*X_0**2
C
*     FUNCTION B_0
      B_0 = ka2/kd2*106.8*X_0
C
*     FUNCTION C_0
      C_0 = kfor/krev*ka3/kd3*kd1/ka1*1.907*A_0
C
*     FUNCTION S1_0
      S1_0 = ka1/kd1*56.0*(1 - X_0)
C
*     FUNCTION S2_0
      S2_0 = ka3/kd3*106.8*(1 - X_0)
C
*     FUNCTION Cg1_0
      Cg1_0 = 1
C
*     FUNCTION Cg2_0
      Cg2_0 = 1
C      
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Cg1_fit
      Cg1_fit = Cg1
C
*     FUNCTION Cg2_fit
      Cg2_fit = Cg2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = 2.9E13/Xtotal - 0.5*A_0 - S1_0
C
*     FUNCTION g2
      g2 = 3.9E13/Xtotal - B_0 - C_0 - S2_0
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C