C
C------------------------------------------------------
C
C     Problem:    COMPSEQ
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      Beta=2000
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Da, Eta, V, I, yA, yB, yR, yS, Thetamix, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Vp
      Vp=1
C
*     FUNCTION Ip
      Theta=T+0.01
      Ip=(1-I)/Theta-I/Thetamix
C
*     FUNCTION yAp
      If (Theta.lt.1.0) THEN
        A=Theta
      ELSE
        A=1
      endif
      yAp= (1-yA)/A-Da*Beta*(yA*yB-I*Eta)
C
*     FUNCTION yBp
      yBp= (Eta-yB)/A-Beta*Da*(yA*YB-I*Eta)-Da*yA*yR
C
*     FUNCTION yRp
      yRp= -yR/A+Beta*Da*(Ya*yB-I*Eta)-Da*yB*yR
C
*     FUNCTION ySp
      ySp= -Ys/A+Da*yB*yR
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION V_0
      V_0 = 0
C
*     FUNCTION I_0
      I_0 = 1 
C
*     FUNCTION yA_0
      yA_0 = 1
C
*     FUNCTION yB_0
      yB_0 = Eta
C
*     FUNCTION yR_0
      yR_0 = 0.01
C
*     FUNCTION yS_0
      yS_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Sel
      Sel= 2*yS/(yR+2*yS)
C
*     FUNCTION V_fit
      V_fit = V
C
*     FUNCTION I_fit
      I_fit = I
C
*     FUNCTION yA_fit
      yA_fit = yA
C
*     FUNCTION yB_fit
      yB_fit = yB
C
*     FUNCTION yR_fit
      yR_fit = yR
C
*     FUNCTION yS_fit
      yS_fit = yS
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

