C
C------------------------------------------------------
C
C     Problem:    COMPREAC
C
C     Date:       23.01.2001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, K3, K4, K5, K6, K7, K8, A, B, C, D, E, F, G, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION AP
      R1= K1*A*B  
      R2= K2*A*C  
      R3= K3*C*D  
      R4= K4*B*D  
      R5= K5*C*C  
      R6= K6*C*B  
      R7= K7*A*G  
      R8= K8*A*F  
      AP= -R1-R2-R7-R8
C
*     FUNCTION BP
      BP= -R1-R4-R6   
C
*     FUNCTION CP
      CP= R1-R2-R3-R5-R6  
C
*     FUNCTION DP
      DP= R2-R3-R4
C
*     FUNCTION EP
      EP= R3+R8   
C
*     FUNCTION FP
      FP= R4+R5+R7-R8 
C
*     FUNCTION GP
      GP= R6-R7   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION A0
      A0= 0.15
C
*     FUNCTION B0
      B0= 0.1
C
*     FUNCTION C0
      C0= 0
C
*     FUNCTION D0
      D0= 0
C
*     FUNCTION E0
      E0= 0
C
*     FUNCTION F0
      F0= 0
C
*     FUNCTION G0
      G0= 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION AFIT
      AFIT= A
C
*     FUNCTION BFIT
      BFIT= B
C
*     FUNCTION CFIT
      CFIT= C
C
*     FUNCTION DFIT
      DFIT= D
C
*     FUNCTION EFIT
      EFIT= E
C
*     FUNCTION FFIT
      FFIT= F
C
*     FUNCTION GFIT
      GFIT= G
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
