C
C------------------------------------------------------
C
C     Problem:    COMPASM
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      UMA=0.4
      KSA=50
      KSB1=0.1
      KSB2=100  
      YA=1
      YB=1
      YBG=100
      F=0.3
      V=1 
      S10=1000
      S20=1500
      KG=5
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      UMB1, UMB2, PA, XA, XB, S1, S2, G, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XAP
      UA=UMA*S1/(KSA+S1)
      UB1=(G/(KG+G))*(UMB1*(S1/(KSB1+S1)))
      UB2=(G/(KG+G))*(UMB2*(S2/(KSB2+S2)))
      XAP=-F*XA/V+UA*XA
C
*     FUNCTION XBP
      XBP=-F*XB/V+(UB1+UB2)*XB
C
*     FUNCTION S1P
      S1P=(F/V)*(S10-S1)-UA*XA/YA-(UB1+UB2)*XB/YB
C
*     FUNCTION S2P
      S2P=(F/V)*(S20-S2)-(UB1+UB2)*XB/YB
C
*     FUNCTION GP
      GP=PA*UA*XA-(UB1+UB2)*XB/YBG-(F/V)*G
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION XA_0
      XA_0=1
C
*     FUNCTION XB_0
      XB_0=1
C
*     FUNCTION S1_0
      S1_0=0
C
*     FUNCTION S2_0
      S2_0=0
C
*     FUNCTION G_0
      G_0=0.01
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION XA_fit
      XA_fit=XA
C
*     FUNCTION XB_fit
      XB_fit=XB
C
*     FUNCTION S1_fit
      S1_fit=S1
C
*     FUNCTION S2_fit
      S2_fit=S2
C
*     FUNCTION G_fit
      G_fit=G
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
