C
C------------------------------------------------------
C
C     Problem:    COMMENSA
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      umby = 0.497
      umbz = 0.532
      ksay = 0.004
      ksaz = 0.001
      ksby = 0.004
      ksbz = 0.001
      ysay = 0.503
      ysaz = 0.3
      ysby = 0.33
      ysbz = 0.37
      yoay = 2.25
      yoaz = 2.32
      yoby = 1.58
      yobz = 2.1 
      ycay = 1.6
      ycaz = 0.9
      ycby = 0.85
      ycbz = 0.93 
      yi = 0.05  
      kpaz = 0.4
      kpby = 0.12 
      beta = 0.001 
      moay = 0.0
      moaz = 0.1
      moby = 0.06
      mobz = 0.0   
      mcay = 0.11
      mcaz = 0.08
      mcby = 0.1
      mcbz = 0.0  
      eay = 1
      ebz = 1   
      keaz = 0.001
      keby = 0.001  
      kraz = 0.00001
      krby = 0.3  
      klac0 = 0.585  
      xa0 = 0.001
      xb0 = 0.01  
      sy0 = 0.74
      sz0 = 0.8   
      i0 = 0.0   
      eaz0 = 0.01
      eby0 = 0.01
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      umay, umaz, ki
      xa, xb, i, eaz, eby, sy, sz, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION xa_t
      IF (t.lt.6) THEN
        alpha = 0.007
      ELSE
        alpha = 0.0007
      ENDIF
      uay = umay * sy * eay/(ksay + sy) 
      uaz = umaz * sz * eaz/(ksaz + sz) 
      uby = umby * sy * eby/(ksby + sy) 
      ubz = (umbz * sz * ebz/(ksbz + sz)) * (ki/(ki + i))   
      rxa = (uay + uaz) * xa  
      rxb = (uby + ubz) * xb  
      xa_t = rxa 
C
*     FUNCTION xb_t
      xb_t = rxb 
C
*     FUNCTION i_t  
      i_t = alpha * uay * xa - beta * xa 
C
*     FUNCTION eaz_t   
      indaz = sz/(keaz + sz)  
      repaz = kraz/(kraz + sy)
      eaz_t = kpaz * (indaz * repaz - eaz)   
C
*     FUNCTION eby_t  
      indby = sy/(keby + sy)  
      repby = krby/(krby + sz)
      eby_t = kpby * (indby * repby - eby)   
C
*     FUNCTION sy_t 
      rsy = -uay * xa * (1/ysay + alpha/yi) - uby/ysby * xb   
      sy_t = rsy 
C
*     FUNCTION sz_t
      rsz = -ubz/ysbz * xb - uaz/ysaz * xa
      sz_t = rsz
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION xa_0
      IF (t.LT.1) THEN
        xa_0=xa0
      ELSE
        xa_0=xa
      ENDIF
C
*     FUNCTION xb_0
      IF (t.LT.1) THEN
        xb_0=xb0
      ELSE
        xb_0=xb
      ENDIF
C
*     FUNCTION i_0
      IF (t.LT.1) THEN
        i_0=i0
      ELSE
        i_0=i
      ENDIF
C
*     FUNCTION eaz_0
      IF (t.LT.1) THEN
        eaz_0=eaz0
      ELSE
        eaz_0=eaz
      ENDIF
C
*     FUNCTION eby_0
      IF (t.LT.1) THEN
        eby_0=eby0
      ELSE
        eby_0=eby
      ENDIF
C
*     FUNCTION sy_0
      IF (t.LT.1) THEN
        sy_0=sy0
      ELSE
        sy_0=sy
      ENDIF
C
*     FUNCTION sz_0
      IF (t.LT.1) THEN
        sz_0=sz0
      ELSE
        sz_0=sz
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fa_fit
      fa = xa/(xa + xb) 
      fa_fit=fa
C
*     FUNCTION fb_fit
      fb_fit = 1 - fa   
C
*     FUNCTION xa_fit
      xa_fit=xa
C
*     FUNCTION xb_fit
      xb_fit=xb
C
*     FUNCTION i_fit
      i_fit=i
C
*     FUNCTION eaz_fit
      eaz_fit=eaz
C
*     FUNCTION eby_fit
      eby_fit=eby
C
*     FUNCTION sy_fit
      sy_fit=sy
C
*     FUNCTION sz_fit
      sz_fit=sz
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

