C
C------------------------------------------------------
C
C     Problem:    COLLISIO
C
C     Date:       30.03.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      s = 1e-5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      n1, n2, y1, y2, y3, y4, y5, y6, y7, y8, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      m1 = n1*40.0/6.022E+13
      m2 = n2*m1/2.0
      y1_t = y5/m1*s
C
*     FUNCTION y2_t
      y2_t = y6/m1*s
C
*     FUNCTION y3_t
      y3_t = y7/m2*s
C
*     FUNCTION y4_t
      y4_t = y8/m2*s
C
*     FUNCTION y5_t
      rx = y1 - y3                
      ry = y2 - y4    
      r2 = rx**2 + ry**2
      rn = 11.6/r2
      rn2 = rn**2   
      rn4 = rn2**2
      vr = -342.4*rn4*(1 - 2*rn2*rn) 
      y5_t = rx*vr*s
C
*     FUNCTION y6_t
      y6_t = ry*vr*s
C
*     FUNCTION y7_t
      y7_t = -rx*vr*s
C
*     FUNCTION y8_t
      y8_t = -ry*vr*s
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = -13.4
C
*     FUNCTION y2_0
      y2_0 = -3
C
*     FUNCTION y3_0
      y3_0 = 14.1
C
*     FUNCTION y4_0
      y4_0 = 3
C
*     FUNCTION y5_0
      m1 = n1*40.0/6.022E+13
      y5_0 = 1.71E+2*m1
C
*     FUNCTION y6_0
      y6_0 = 0
C
*     FUNCTION y7_0
      m2 = n2*m1/2.0
      y7_0 = -1.711E+2*m2
C
*     FUNCTION y8_0
      y8_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y4_fit = y4
C
*     FUNCTION y5_fit
      y5_fit = y5
C
*     FUNCTION y6_fit
      y6_fit = y6
C
*     FUNCTION y7_fit
      y7_fit = y7
C
*     FUNCTION y8_fit
      y8_fit = y8
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





