C
C------------------------------------------------------
C
C     Problem:    COLLAGEN
C
C     Date:       26.05.2003
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Da = 0.0965
      beta2 = 6
      Ccx = 5.4
      Cax = 0.2      
      Cc0 = 3.1
      Ca0 = 0.02
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (One
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.)
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Dc, beta1, Cc, Ca, Cc_x, Ca_x, Cc_xx, Ca_xx, fc, fa, fc_x, fa_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux_c
      flux_c = Dc*exp(-beta1*(1 - Cc/Ccx))
C
*     FUNCTION flux_a
      flux_a = Da*exp(-beta2*(1 - Ca/Cax))
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION Cc_t
      Cc_t = fc_x
C
*     FUNCTION Ca_t
      Ca_t = fa_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION Cc_0
      Cc_0 = Cc0
C
*     FUNCTION Ca_0
      Ca_0 = Ca0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION Cc_right
      Cc_right = 0
C
*     FUNCTION Ca_right
      Ca_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION Cc_x_left
      Cc_x_left = 0
C
*     FUNCTION Ca_x_left
      Ca_x_left = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fitc
      fitc = simpsn(1,1)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
