C
C------------------------------------------------------
C
C     Problem:    COAL7
C
C     Date:       23.10.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Ta = 383
      Te = 1250
      H20 = 0
      CO20 = 0
      CO0 = 0
      CH40 = 0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      yH2_inf, alphaH2, betaH2
      yCO21_inf, alphaCO21, betaCO21 
      yCO22_inf, alphaCO22, betaCO22 
      yCO1_inf, alphaCO1, betaCO1
      yCO2_inf, alphaCO2, betaCO2
      yCH4_inf, alphaCH4, betaCH4
      yH2, yCO21, yCO22, yCO1, yCO2, yCH4, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION yH2_T
      if (T.lt.Ta) then
        yH2_T = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kH2 = exp(alphaH2*tau + betaH2*(1-tau))
        yH2_T = kH2*(yH2_inf - yH2)
      endif
C
*     FUNCTION yCO21_T
      if (T.lt.Ta) then
        yCO21_T = 0
      else
        kCO21 = exp(alphaCO21*tau + betaCO21*(1-tau))
        yCO21_T = kCO21*(yCO21_inf - yCO21)
      endif
C
*     FUNCTION yCO22_T
      if (T.lt.Ta) then
        yCO22_T = 0
      else
        kCO22 = exp(alphaCO22*tau + betaCO22*(1-tau))
        yCO22_T = kCO22*(yCO22_inf - yCO22)
      endif
C
*     FUNCTION yCO1_T
      if (T.lt.Ta) then
        yCO1_T = 0
      else
        kCO1 = exp(alphaCO1*tau + betaCO1*(1-tau))
        yCO1_T = kCO1*(yCO1_inf - yCO1)
      endif
C
*     FUNCTION yCO2_T
      if (T.lt.Ta) then
        yCO2_T = 0
      else
        kCO2 = exp(alphaCO2*tau + betaCO2*(1-tau))
        yCO2_T = kCO2*(yCO2_inf - yCO2)
      endif
C
*     FUNCTION yCH4_T
      if (T.lt.Ta) then
        yCH4_T = 0
      else
        kCH4 = exp(alphaCH4*tau + betaCH4*(1-tau))
        yCH4_T = kCH4*(yCH4_inf - yCH4)**2
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION yH2_0
      yH2_0 = H20
C
*     FUNCTION yCO21_0
      yCO21_0 = CO20
C
*     FUNCTION yCO22_0
      yCO22_0 = CO20
C
*     FUNCTION yCO1_0
      yCO1_0 = CO0
C
*     FUNCTION yCO2_0
      yCO2_0 = CO0
C
*     FUNCTION yCH4_0
      yCH4_0 = CH40
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION yH2_fit
      if (T.lt.Ta) then
        yH2_fit = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kH2 = exp(alphaH2*tau + betaH2*(1-tau))
        yH2_fit = kH2*(yH2_inf - yH2)
       endif
C
*     FUNCTION yCO2_fit
      if (T.lt.Ta) then
        yCO2_fit = 0
      else
        kCO21 = exp(alphaCO21*tau + betaCO21*(1-tau))
        kCO22 = exp(alphaCO22*tau + betaCO22*(1-tau))
        yCO2_fit = kCO21*(yCO21_inf - yCO21) + 
     /             kCO22*(yCO22_inf - yCO22)
      endif
C
*     FUNCTION yCO_fit
      if (T.lt.Ta) then
        yCO_fit = 0
      else
        kCO1 = exp(alphaCO1*tau + betaCO1*(1-tau))
        kCO2 = exp(alphaCO2*tau + betaCO2*(1-tau))
        yCO_fit = kCO1*(yCO1_inf - yCO1) + kCO2*(yCO2_inf - yCO2)
      endif
C
*     FUNCTION yCH4_fit
      if (T.lt.Ta) then
        yCH4_fit = 0
      else
        kCH4 = exp(alphaCH4*tau + betaCH4*(1-tau))
        yCH4_fit = kCH4*(yCH4_inf - yCH4)**2
      endif
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

