C
C------------------------------------------------------
C
C     Problem:    COAL6
C
C     Date:       23.10.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Ta = 383
      Te = 1250
      CH40 = 0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      yCH4_inf, alphaCH4, betaCH4
      yCH4, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION yCH4_T
      if (T.lt.Ta) then
        yCH4_T = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kCH4 = exp(alphaCH4*tau + betaCH4*(1-tau))
        yCH4_T = kCH4*(yCH4_inf - yCH4)**2
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION yCH4_0
      yCH4_0 = CH40
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION yCH4T_fit
      if (T.lt.Ta) then
        yCH4T_fit = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kCH4 = exp(alphaCH4*tau + betaCH4*(1-tau))
        yCH4T_fit = kCH4*(yCH4_inf - yCH4)**2
      endif
C
*     FUNCTION yCH4_fit
      yCH4_fit = yCH4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


