C
C------------------------------------------------------
C
C     Problem:    COAL5
C
C     Date:       23.10.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Ta = 383
      Te = 1250
      CO0 = 0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      yCO1_inf, alphaCO1, betaCO1 
      yCO2_inf, alphaCO2, betaCO2 
      yCO1, yCO2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION yCO1_T
      if (T.lt.Ta) then
        yCO1_T = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kCO1 = exp(alphaCO1*tau + betaCO1*(1-tau))
        yCO1_T = kCO1*(yCO1_inf - yCO1)
      endif
C
*     FUNCTION yCO2_T
      if (T.lt.Ta) then
        yCO2_T = 0
      else
        kCO2 = exp(alphaCO2*tau + betaCO2*(1-tau))
        yCO2_T = kCO2*(yCO2_inf - yCO2)
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION yCO1_0
      yCO1_0 = CO0
C
*     FUNCTION yCO2_0
      yCO2_0 = CO0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION yCO_fit
      if (T.lt.Ta) then
        yCO_fit = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kCO1 = exp(alphaCO1*tau + betaCO1*(1-tau))
        kCO2 = exp(alphaCO2*tau + betaCO2*(1-tau))
        yCO_fit = kCO1*(yCO1_inf - yCO1) + 
     /            kCO2*(yCO2_inf - yCO2)
      endif
C
*     FUNCTION yCO1_fit
      if (T.lt.Ta) then
        yCO1_fit = 0
      else
        yCO1_fit = yCO1
      endif
C
*     FUNCTION yCO2_fit
      if (T.lt.Ta) then
        yCO2_fit = 0
      else
        yCO2_fit = yCO2
      endif
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

