C
C------------------------------------------------------
C
C     Problem:    COAL4
C
C     Date:       23.10.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Ta = 383
      Te = 1250
      CO20 = 0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      yCO21_inf, alphaCO21, betaCO21 
      yCO22_inf, alphaCO22, betaCO22 
      yCO21, yCO22, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION yCO21_T
      if (T.lt.Ta) then
        yCO21_T = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kCO21 = exp(alphaCO21*tau + betaCO21*(1-tau))
        yCO21_T = kCO21*(yCO21_inf - yCO21)
      endif
C
*     FUNCTION yCO22_T
      if (T.lt.Ta) then
        yCO22_T = 0
      else
        kCO22 = exp(alphaCO22*tau + betaCO22*(1-tau))
        yCO22_T = kCO22*(yCO22_inf - yCO22)
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION yCO21_0
      yCO21_0 = CO20
C
*     FUNCTION yCO22_0
      yCO22_0 = CO20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION yCO2_fit
      if (T.lt.Ta) then
        yCO2_fit = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kCO21 = exp(alphaCO21*tau + betaCO21*(1-tau))
        kCO22 = exp(alphaCO22*tau + betaCO22*(1-tau))
        yCO2_fit = kCO21*(yCO21_inf - yCO21) + 
     /             kCO22*(yCO22_inf - yCO22)
      endif
C
*     FUNCTION yCO21_fit
      if (T.lt.Ta) then
        yCO21_fit = 0
      else
        yCO21_fit = yCO21
      endif
C
*     FUNCTION yCO22_fit
      if (T.lt.Ta) then
        yCO22_fit = 0
      else
        yCO22_fit = yCO22
      endif
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

