C
C------------------------------------------------------
C
C     Problem:    COAL3
C
C     Date:       23.10.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Ta = 383
      Te = 1250
      H20 = 0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      yH2_inf, alphaH2, betaH2, yH2,T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION yH2_T
      if (T.lt.Ta) then
        yH2_T = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kH2 = exp(alphaH2*tau + betaH2*(1-tau))
        yH2_T = kH2*(yH2_inf - yH2)**2
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION yH2_0
      yH2_0 = H20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION yH2T_fit
      if (T.lt.Ta) then
        yH2T_fit = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kH2 = exp(alphaH2*tau + betaH2*(1-tau))
        yH2T_fit = kH2*(yH2_inf - yH2)**2
       endif
C
*     FUNCTION yH2_fit
      yH2_fit = yH2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
