C
C------------------------------------------------------
C
C     Problem:    COAL1
C
C     Date:       23.10.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Ta = 383
      Te = 1250
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      alphaCO2, betaCO2, alphaCO, betaCO
      alphaCH4, betaCH4, alphaH2, betaH2
      C0, H0, O0, yC, yH, yO, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION yC_T
      if (T.lt.Ta) then
        yC_T = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kCO2 = exp(alphaCO2*tau + betaCO2*(1-tau))
        if (yC.lt.yO/2) then
          yCO2_T = kCO2*yC
        else
          yCO2_T = kCO2*yO/2
        endif
        kCO = exp(alphaCO*tau + betaCO*(1-tau))
        if (yC.lt.yO) then
          yCO_T = kCO*yC
        else
          yCO_T = kCO*yO
        endif
        kCH4 = exp(alphaCH4*tau + betaCH4*(1-tau))
        if (yC.lt.yH/4) then
          yCH4_T = kCH4*yC
        else
          yCH4_T = kCH4*yH/4
        endif
        kH2 = exp(alphaH2*tau + betaH2*(1-tau))
        yH2_T = kH2*yH/2
        yC_T = -yCO2_T - yCO_T - yCH4_T 
      endif
C
*     FUNCTION yH_T
      if (T.lt.Ta) then
        yH_T = 0
      else
        yH_T = -2*yH2_T - 4*yCH4_T 
      endif
C
*     FUNCTION yO_T
      if (T.lt.Ta) then
        yO_T = 0
      else
        yO_T = -2*yCO2_T - yCO_T 
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION yC_0
      yC_0 = C0
C
*     FUNCTION yH_0
      yH_0 = H0
C
*     FUNCTION yO_0
      yO_0 = O0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION yH2_fit
      if (T.lt.Ta) then
        yH2_fit = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kH2 = exp(alphaH2*tau + betaH2*(1-tau))
        yH2_T = kH2*yH/2
        yH2_fit = yH2_T
       endif
C
*     FUNCTION yCO2_fit
      if (T.lt.Ta) then
        yCO2_fit = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kCO2 = exp(alphaCO2*tau + betaCO2*(1-tau))
        if (yC.lt.yO/2) then
          yCO2_T = kCO2*yC
        else
          yCO2_T = kCO2*yO/2
        endif
        yCO2_fit = yCO2_T
      endif
C
*     FUNCTION yCO_fit
      if (T.lt.Ta) then
        yCO_fit = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kCO = exp(alphaCO*tau + betaCO*(1-tau))
        if (yC.lt.yO) then
          yCO_T = kCO2*yC
        else
          yCO_T = kCO2*yO
        endif
        yCO_fit = yCO_T
      endif
C
*     FUNCTION yCH4_fit
      if (T.lt.Ta) then
        yCH4_fit = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        kCH4 = exp(alphaCH4*tau + betaCH4*(1-tau))
        if (yC.lt.yH/4) then
          yCH4_T = kCH4*yC
        else
          yCH4_T = kCH4*yH/4
        endif
        yCH4_fit = yCH4_T
      endif
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C






