C
C------------------------------------------------------
C
C     Problem:    COAL1
C
C     Date:       23.10.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Ta = 383
      Te = 1250
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      y_inf1, alpha1, beta1, y_inf2, alpha2, beta2
      y1, y2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_T
      if (T.lt.Ta) then
        y1_T = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        k1 = exp(alpha1*tau + beta1*(1-tau))
        y1_T = k1*(y_inf1 - y1)
      endif
C
*     FUNCTION y2_T
      if (T.lt.Ta) then
        y2_T = 0
      else
        k2 = exp(alpha2*tau + beta2*(1-tau))
        y2_T = k2*(y_inf2 - y2)
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 0
C
*     FUNCTION y2_0
      y2_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y_fit
      if (T.lt.Ta) then
        y_fit = 0
      else
        tau = Ta/T*(T - Te)/(Ta - Te)
        k1 = exp(alpha1*tau + beta1*(1-tau))
        y1T = k1*(y_inf1 - y1)
        k2 = exp(alpha2*tau + beta2*(1-tau))
        y2T = k2*(y_inf2 - y2)
        y_fit = y1T + y2T
      endif
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C







