C
C------------------------------------------------------
C
C     Problem:     CO2_SOL1
C
C     Date:        20.07.2004
C
C------------------------------------------------------
C                                          
*     PARAMETER
      nT = 1      
      nA = 2
      nP = 7
C
C------------------------------------------------------
C 
*     LININT tabT
      1.0  293.0   
      2.0  303.0
      3.0  313.0
      4.0  323.0
C 
*     LININT tabA
      1.0  1.0   
      2.0  0.6
      3.0  0.4
      4.0  0.2
      5.0  0.1
C 
*     LININT tabP
      1.0  95.1   
      2.0  47.6
      3.0  28.6
      4.0  19.1
      5.0   9.5
      6.0   4.7
      7.0   1.0
C
C-----------------------------------------------------------   
C
*     REAL CONSTANT
      a1   = -11.91
      a5   = 216
      a6   = 214.4
      a7   = 132.9
      a8   = 94.4914
      b1   = 4351
      b5   = 12432
      b6   = 12092
      b7   = 13446
      b8   = 6789.04
      c1   = 0
      c5   = 35.48
      c6   = 36.78
      c7   = 22.48
      c8   = 11.4519
      x1s  = 1
      x2s  = 1
      x3s  = 1
      x4s  = 1
      x5s  = 1
      x6s  = 1
      x7s  = 1
      x8s  = 1
      x9s  = 1
      x10s = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (a),(b),(C)
C     2. system variables (X)
C     3. concentration variable, if exists (A)
C     4. time variable (T)
C
*     VARIABLE
      a2, a3, a4, b2, b3, b4, c2, c3, c4
      x1, x2, x3, x4, x5, x6, x7, x8, x9, x10
      i
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION equ1           
c     i = nA*nP*(iT-1) + nP*(iA-1) + iP  
      iT = 1   
      iA = 1
      if (i-nP.gt.0) then
        iA = iA + 1
      endif               
      iP = i - nP*(iA - 1)
      T  = tabT(iT)  
      A  = tabA(iA)
      P  = tabP(iP)
      K1 = exp(a1 - b1/T - c1*log(T))
      K2 = exp(a2 - b2/T - c2*log(T))
      K3 = exp(a3 - b3/T - c3*log(T))
      K4 = exp(a4 - b4/T - c4*log(T))
      K5 = exp(a5 - b5/T - c5*log(T))
      K6 = exp(a6 - b6/T - c6*log(T))
      K7 = exp(a7 - b7/T - c7*log(T)) 
      K8 = exp(a8 - b8/T - c8*log(T) - 0.010454*T) 
      equ1 = x1*x4 - k1*x2
C
*     FUNCTION equ2
      equ2 = x3*x8 - K2*x2*x9      
C
*     FUNCTION equ3
      equ3 = x4*x8 - K3*x3*x9
C
*     FUNCTION equ4
      equ4 = x3*x9 - K4*x5
C    
*     FUNCTION equ5
      equ5 = x7*x8 - K5*x6
C
*     FUNCTION equ6
      equ6 = X6*x8 - K6*x9
c
*     FUNCTION equ7
      equ7 = x10*x8 - K7
C     
*     FUNCTION equ8
      equ8 = P - K8*x9
C
*     FUNCTION equ9
      equ9 = x1 + x2 + x3 + x4 + x5 - A
C
*     FUNCTION equ10
      equ10 = x3 + 2*x4 + x6 + 2*x7 - x8 - x2

C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION x1_0
      x1_0 = x1s
C
*     FUNCTION x2_0
      x2_0 = x2s
C
*     FUNCTION x3_0
      x3_0 = x3s
C
*     FUNCTION x4_0
      x4_0 = x4s
C 
*     FUNCTION x5_0
      x5_0 = x5s
C
*     FUNCTION x6_0
      x6_0 = x6s 
C
*     FUNCTION x7_0
      x7_0 = x7s 
C
*     FUNCTION x8_0
      x8_0 = x8s 
C
*     FUNCTION x9_0
      x9_0 = x9s  
C
*     FUNCTION x10_0
      x10_0 = x10s

C------------------------------------------------------
C
C   - Fitting criterion:
C                                                                                                                                    
*     FUNCTION C
      C = x9 + x6 + x7 + x3 + x5 + 2*x4
C                                                                                                                                    
*     FUNCTION plot1
      plot1 = x1
C                                                                                                                                    
*     FUNCTION plot2
      plot2 = x2
C                                                                                                                                    
*     FUNCTION plot3
      plot3 = x3
C                                                                                                                                    
*     FUNCTION plot4
      plot4 = x4
C                                                                                                                                    
*     FUNCTION plot5
      plot5 = x5
C                                                                                                                                    
*     FUNCTION plot6
      plot6 = x6
C                                                                                                                                    
*     FUNCTION plot7
      plot7 = x7
C                                                                                                                                    
*     FUNCTION plot8
      plot8 = x8
C                                                                                                                                    
*     FUNCTION plot9
      plot9 = x9
C                                                                                                                                    
*     FUNCTION plot10
      plot10 = x10
C                                                                                                                                    
*     FUNCTION plot11
      iT = 1   
      iA = 1
      if (i-nP.gt.0) then
        iA = iA + 1
      endif               
      iP = i - nP*(iA - 1)
      plot11 = tabT(iT)  
C                                                                                                                                    
*     FUNCTION plot12
      plot12 = tabA(iA)  
C                                                                                                                                    
*     FUNCTION plot13
      plot13 = tabP(iP)  
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
