C
C------------------------------------------------------
C
C     Problem:    CN_PLAS
C
C     Date:       11.01.2002
C
C------------------------------------------------------
C
*     PARAMETER
      n = 8
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      gamma, B1b
      rho, m1, m2, B2, e
      rho_x, m1_x, m2_x, B2_x, e_x
      rho_xx, m1_xx, m2_xx, B2_xx, e_xx
      frho, fm1, fm2, fB2, fe
      frho_x, fm1_x, fm2_x, fB2_x, fe_x
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux 
C
*     FUNCTION flux_rho
      flux_rho = -m1
C
*     function flux_m1
      flux_m1 = -(m1**2/rho - B1b**2 + (gamma - 1)*e 
     /          - (gamma - 1)*(m1**2 + m2**2)/(2*rho)
     /          + (2 - gamma)*(B1b**2 + B2**2)/2)
C
*     function flux_m2
      flux_m2 = -(m1*m2/rho - B1b*B2)
C
*     function flux_B2
      flux_B2 = -(B2*m1/rho - B1b*m2/rho)
C
*     function flux_e
      flux_e = -m1/rho*(gamma*e - (gamma - 1)*(m1**2 + m2**2)/(2*rho)
     /         + (2 - gamma)*(B1b**2 + B2**2)/2
     /         - B1b*(B1b*m1/rho + B2*m2/rho))
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION rho_t
      rho_t = frho_x
C
*     FUNCTION m1_t
      m1_t = fm1_x
C
*     FUNCTION m2_t
      m2_t = fm2_x
C
*     FUNCTION B2_t
      B2_t = fB2_x
C
*     FUNCTION e_t
      e_t = fe_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION rho_0
      if (x.le.0.5) then
        rho_0 = 1
      else      
        rho_0 = 1 - (x-0.5)*3
      endif      
      if (rho_0.lt.0.125) then
         rho_0 = 0.125
      endif   
C
*     FUNCTION m1_0
      m1_0 = 0
C
*     FUNCTION m2_0
      m2_0 = 0
C
*     FUNCTION B2_0
      if (x.le.0.5) then
        B2_0 = 1
      else
        B2_0 = 1 - (x-0.5)*8
      endif
      if (B2_0.lt.-1) then
         B2_0 = -1
      endif   
C
*     FUNCTION e_0
      if (x.le.0.5) then
        e_0 = 1.78125
      else
        e_0 = 1.78125 - (x - 0.5)*4 
      endif
      if (e_0.lt.0.88125) then
         e_0 = 0.88125
      endif   
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION rho_left
      rho_left = 1
C
*     FUNCTION m1_left
      m1_left = 0
C
*     FUNCTION m2_left
      m2_left = 0
C
*     FUNCTION B2_left
      B2_left = 1
C
*     FUNCTION e_left
      e_left = 1.78125
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
c*     FUNCTION u_x_left
c      u_x_left = 0
C
c*     FUNCTION u_x_right
c      u_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit_rho
      fit_rho = rho
C
*     FUNCTION fit_B2
      fit_B2 = B2
C
*     FUNCTION fit_e
      fit_e = e
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


