C
C------------------------------------------------------
C
C     Problem:    CNT_CUR2
C
C     Date:       5.8.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      h1 = 1
      h2 = 0.1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      l, v, k0, a0
      x1, x2, x3, x1_z, x2_z, x3_z, x1_zz, x2_zz, x3_zz
      f1, f2, f3, f1_z, f2_z, f3_z
      z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C 
C
*     FUNCTION flux1
      flux1 = l/h1*x1
C
*     FUNCTION flux2
      flux2 = -v/h2*x2
C
*     FUNCTION flux3
      flux3 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION x1_t
      x1_t = f1_z + k0*(x2 - x3)/h1
C
*     FUNCTION x2_t
      x2_t = f2_z - k0*(x2 - x3)/h2
C
*     FUNCTION equation
      equation = x3 - a0*x1/(1 + (a0 - 1)*x1)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION x1_0
      x1_0 = 0.2
C
*     FUNCTION x2_0
      x2_0 = 0.05
C
*     FUNCTION x3_0
      x3_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION x2_left
      x2_left = 0.05
C
*     FUNCTION x1_right
      x1_right = 0.2
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit11
      fit11 = x1
C
*     FUNCTION fit21
      fit21 = x2
C
*     FUNCTION fit12
      fit12 = x1
C
*     FUNCTION fit22
      fit22 = x2
C
*     FUNCTION fit13
      fit13 = x1
C
*     FUNCTION fit23
      fit23 = x2
C
*     FUNCTION fit14
      fit14 = x1
C
*     FUNCTION fit24
      fit24 = x2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
