C
C------------------------------------------------------
C
C     Problem:    CLOUD
C
C     Date:       25.11.2001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, y1, y2, n, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = y2
C
*     FUNCTION y2_t
      if (t.gt.0) then
        if (y1.gt.0) then
          y2_t = -a/t*y2 - b*y1**n  
        else
          y2_t = -a/t*y2     
        endif
      else
        y2_t = 0
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 1
C
*     FUNCTION y2_0
      y2_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




