C
C------------------------------------------------------
C
C     Problem:    CIRCUIT
C
C     Date:       20.02.2002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      alpha, gamma, sigma, delta, x, y, z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      x_t = y
C
*     FUNCTION y_t
      y_t = -x - delta*y + z
C
*     FUNCTION z_t
      if (x.le.-1.2) then
        f = 0.528
      else
      if (x.le.1.2) then
        f = x*(1 - x**2)
      else
        f = -0.528
      endif
      endif
      z_t = gamma*(alpha*f - z) - sigma*y
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 3
C
*     FUNCTION y_0
      y_0 = -2
C
*     FUNCTION z_0
      z_0 = 5
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y_fit
      y_fit = y
C
*     FUNCTION z_fit
      z_fit = z
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



