C
C------------------------------------------------------
C
C     Problem:    CIRCLE
C
C     Date:       04.07.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, y1, y2, v1, v2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = v1
C
*     FUNCTION y2_t
      y2_t = v2
C
*     FUNCTION v1_t
      v1_t = -a*t**2*y1 - b*y2/sqrt(y1**2 + y2**2)
C
*     FUNCTION v2_t
      v2_t = -a*t**2*y2 + b*y1/sqrt(y1**2 + y2**2)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 0
C
*     FUNCTION y2_0
      y2_0 = 1
C
*     FUNCTION v1_0
      v1_0 = 0
C
*     FUNCTION v2_0
      v2_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



