C
C------------------------------------------------------
C
C     Problem:    CHSTA_D
C
C     Date:       25.04.2004
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Di = 0.2
      Df = 0.6
      sf = 5
      Dw = 0.75
      Y = 0.4
      Ks = 0.2
      kd = 0.01
      krd = 0.05
      kp = 0.002
      ki = 0.005
      L = 5E3
      N1 = 100
      N = N1*1E8
      Vc = 2
      Vr = 200    
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      Vs, Ve, Kco2
      s0, e0, c0, p0, r0
      s, e, c, p, r
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION s_t
      w = e*s/((Ks + s)*(1 + p/ki))
      rg = Vc*r*p/(kp + p) + Vr*r*p - krd
      s_t = Df*(sf - s) - Vs*w*c
C
*     FUNCTION e_t 
      e_t = Ve*(1 + N*w*w)/(L + N*w*w) - (rg + kd)*e
C
*     FUNCTION c_t
      c_t = (rg - Df)*c
C
*     FUNCTION p_t
      p_t = Vs*w - rg - Kco2*p
C
*     FUNCTION r_t
      r_t = Vr*r*p - (rg + krd)*r
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION s_0
      s_0 = s0
C
*     FUNCTION e_0
      e_0 = e0
C
*     FUNCTION c_0
      c_0 = c0
C
*     FUNCTION p_0
      p_0 = p0
C
*     FUNCTION r_0
      r_0 = r0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION s_fit
      s_fit = s
C
*     FUNCTION c_fit
      c_fit = c
C
*     FUNCTION r_fit
      r_fit = r
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g
      Np = N*(Dw/Y/Vs)**2
      g = Ve*(1 + Np)/(L + Np) - (Dw + kd)*Dw/Y/Vs
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
