C
C------------------------------------------------------
C
C     Problem:    CHRESIGN
C
C     Date:       04.11.2006
C
C------------------------------------------------------
C
*     REAL CONSTANT
      eps_b     = 0.5
      phi       = (1 - eps_b)/eps_b
      beta_A    = 20.629
      beta_B    = 9.669                         
      beta_salt = 0.525
      delta_A   = 8.661E-6
      delta_B   = 1.16E-5   
      Lambda    = 0.525  
      t_feed    = 1.661  
      eps       = 1E-5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential algebraic equations, first
C        the differential, then the algebraic variables (v)
C     6. variables for flux functions, if available (One
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDAE.)
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      K_A, K_B, nu_A, nu_B, St_A, St_B, St_salt, chi_salt_ini
      chi_A, chi_B, theta_A, theta_B, chi_salt, theta_salt 
         theta_s_A, theta_s_B, theta_s_salt
      chi_A_z, chi_B_z, theta_A_z, theta_B_z, chi_salt_z, theta_salt_z
         theta_s_A_z, theta_s_B_z, theta_s_salt_z
      chi_A_zz, chi_B_zz, theta_A_zz, theta_B_zz, chi_salt_zz, theta_salt_zz
         theta_s_A_zz, theta_s_B_zz, theta_s_salt_zz
      z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION chi_A_t                                  
      chi_A_t = -chi_A_z - St_A*phi*beta_A*(theta_s_A - theta_A)
C
*     FUNCTION chi_B_t                                  
      chi_B_t = -chi_B_z - St_B*phi*beta_B*(theta_s_B - theta_B)
C
*     FUNCTION theta_A_t                                  
      theta_A_t = St_A*(theta_s_A - theta_A)
C
*     FUNCTION theta_B_t                                  
      theta_B_t = St_B*(theta_s_B - theta_B)
C
*     FUNCTION chi_salt_t                                  
      chi_salt_t = -chi_salt_z - St_salt*phi*beta_salt*(theta_s_salt - theta_salt)
C
*     FUNCTION theta_salt_t                                  
      theta_salt_t = St_salt*(theta_s_salt - theta_salt)
C
*     FUNCTION equ_A
      equ_A = theta_s_A*abs(chi_salt+eps)**nu_A - delta_A*chi_A*abs(theta_s_salt+eps)**nu_A
C
*     FUNCTION equ_B
      equ_B = theta_s_B*abs(chi_salt+eps)**nu_B - delta_B*chi_B*abs(theta_s_salt+eps)**nu_B
C
*     FUNCTION balance
      balance = theta_s_A + theta_s_B + theta_s_salt - 1      
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION chi_A_0     
      if (t.lt.0.01) then
        chi_A_0 = 0
      else
        chi_A_0 = chi_A 
      endif    
C      
*     FUNCTION chi_B_0
      if (t.lt.0.01) then
        chi_B_0 = 0
      else
        chi_B_0 = chi_B
      endif    
C      
*     FUNCTION theta_A_0
      if (t.lt.0.01) then
        theta_A_0 = 0
      else
        theta_A_0 = theta_A
      endif    
C      
*     FUNCTION theta_B_0
      if (t.lt.0.01) then
        theta_B_0 = 0
      else
        theta_B_0 = theta_B
      endif            
C      
*     FUNCTION chi_salt_0
      if (t.lt.0.01) then
        chi_salt_0 = chi_salt_ini
      else
        chi_salt_0 = chi_salt
      endif            
C      
*     FUNCTION theta_salt_0 
      if (t.lt.0.01) then
        theta_salt_0 = Lambda
      else
        theta_salt_0 = theta_salt
      endif            
C
*     FUNCTION theta_s_A_0
      if (t.lt.0.01) then
        theta_s_A_0 = 0
      else
        theta_s_A_0 = theta_s_A
      endif            
C      
*     FUNCTION theta_s_B_0
      if (t.lt.0.01) then
        theta_s_B_0 = 0
      else
        theta_s_B_0 = theta_s_B
      endif            
C      
*     FUNCTION theta_s_salt_0
      if (t.lt.0.01) then
        theta_s_salt_0 = 1     
      else
        theta_s_salt_0 = theta_s_salt
      endif            
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential algebraic equations,
C     first the differential ones in the order given by 
C     increasing spatial positions, then the algebraic ones
C     ones coupled at increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential algebraic equations at t=0,
C     first for the differential equations in the order
C     given by increasing spatial positions, then for the 
C     algebraic ones ones coupled at increasing spatial 
C     positions:
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION chi_A_left
      if (t.lt.t_feed) then
        chi_A_left = 1
      else
        chi_A_left = 0
      endif    
C
*     FUNCTION chi_B_left
      if (t.lt.t_feed) then
        chi_B_left = 1
      else
        chi_B_left = 0
      endif    
C
*     FUNCTION chi_salt_left
      if (t.lt.t_feed) then
        chi_salt_left = chi_salt_ini
      else                             
        A = -chi_salt_z - St_salt*phi*beta_salt*(theta_s_salt - theta_salt) 
        A=0   
        chi_salt_left = chi_salt_ini + A*(t - t_feed)
      endif    
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
c*     FUNCTION chi_A_right_z
c      chi_A_right_z = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION chi_A_fit
      chi_A_fit = chi_A
C
*     FUNCTION chi_B_fit
      chi_B_fit = chi_B
C
*     FUNCTION chi_salt_fit
      chi_salt_fit = chi_salt
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C