C
C------------------------------------------------------
C
C     Problem:    CHEM_REA
C
C     Date:       3/19/99
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, k5, k6, k7, k8, k9, k10, k11, k12
      k13, k14, k15, k16, k17
      C1, C2, C3, C4, C5, C6, C7, C8, C9, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dC1_dt
      dC1_dt=-(k1+k2+k3+k4)*C1
C
*     FUNCTION dC2_dt
      dC2_dt=k1*C1 - (k5+k6+k7)*C2
C
*     FUNCTION dC3_dt
      dC3_dt=k2*C1 - (k8+k9)*C3
C
*     FUNCTION dC4_dt
      dC4_dt=k3*C1 - (k10+k11+k12)*C4
C
*     FUNCTION dC5_dt
      dC5_dt=k4*C1 - k13*C5
C
*     FUNCTION dC6_dt
      dC6_dt=k5*C2 + k8*C3 - k14*C6
C
*     FUNCTION dC7_dt
      dC7_dt=k6*C2 + k10*C4 - k15*C7
C
*     FUNCTION dC8_dt
      dC8_dt=k9*C3 + k11*C4 - k16*C8
C
*     FUNCTION dC9_dt
      dC9_dt=k7*C2 + k12*C3 + k13*C5- k17*C9
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION C1_0
      C1_0 = 5.7916e-7
C
*     FUNCTION C2_0
      C2_0 = 0
C
*     FUNCTION C3_0
      C3_0 = 0
C
*     FUNCTION C4_0
      C4_0 = 0
C
*     FUNCTION C5_0
      C5_0 = 0
C
*     FUNCTION C6_0
      C6_0 = 0
C
*     FUNCTION C7_0
      C7_0 = 0
C
*     FUNCTION C8_0
      C8_0 = 0
C
*     FUNCTION C9_0
      C9_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION C1_fit
      C1_fit = C1
C
*     FUNCTION C2_fit
      C2_fit = C2
C
*     FUNCTION C3_fit
      C3_fit = C3
C
*     FUNCTION C4_fit
      C4_fit = C4
C
*     FUNCTION C5_fit
      C5_fit = C5
C
*     FUNCTION C6_fit
      C6_fit = C6
C
*     FUNCTION C7_fit
      C7_fit = C7
C
*     FUNCTION C8_fit
      C8_fit = C8
C
*     FUNCTION C9_fit
      C9_fit = C9
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
