C
C------------------------------------------------------
C
C     Problem:    CHEM_OSC
C
C     Date:       18.04.97
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, k5, k6, k_4, k_5, Etot, j
      x1, x2, x3, x4, x5, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_p
      x1_p = j - k1*x1 - k4*x1*x4 + k_4*(Etot - x4 - x5)
C
*     FUNCTION x2_p
      x2_p = k1*x1 - k2*x2
C
*     FUNCTION x3_p
      x3_p = k2*x2 - k3*x3 - k_5*x3*(Etot - x4 - x5)
     /        + (k_5 + k6)*x5
C
*     FUNCTION x4_p
      x4_p = -k4*x1*x4 + k_4*(Etot - x4 - x5) + k6*x5
C
*     FUNCTION x5_p
      x5_p = k5*x3*(Etot - x4 - x5) - (k_5 + k6)*x5
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 9.0
C
*     FUNCTION x2_0
      x2_0 = 7.0
C
*     FUNCTION x3_0
      x3_0 = 0.003
C
*     FUNCTION x4_0
      x4_0 = 0.005
C
*     FUNCTION x5_0
      x5_0 = 0.00015
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION x5_fit
      x5_fit = x5
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

