C
C------------------------------------------------------
C
C     Problem:     CHEM_EQU
C
C     Date:        26.11.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      u = 0.3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, M, N, R, V, p
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION g1
      if (p.gt.0) then
        g1 = (M**2*(3 - V) - k1*N**2*V*sqrt(p))/SQRT(P)
      else
        g1 = 0
      endif
C
*     FUNCTION g2
      g2 = M*R - k2*N**2
C
*     FUNCTION g3
      g3 = M + 2*V - (N + u)
C
*     FUNCTION g4
      g4 = M + N + R - 1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION M_0
      M_0 = 0.1
C
*     FUNCTION N_0
      N_0 = 0.1
C
*     FUNCTION R_0
      R_0 = 0.1
C
*     FUNCTION V_0
      V_0 = 0.16
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION fit1
      fit1 = V
C
*     FUNCTION fit2
      fit2 = M
C
*     FUNCTION fit3
      fit3 = N
C
*     FUNCTION fit4
      fit4 = R
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

