C
C------------------------------------------------------
C
C     Problem:     CHEMSTAT
C
C     Date:        29.1.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      s0 = 10
      r  = 0.09
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (z)
C     3. time variable (t)
C
*     VARIABLE
      k1, k2, e, c, s, D
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION g1
      g1 = r*k2*c - D*0.0553*e
C
*     FUNCTION g2
      g2 = k1*s*(e - c) - k2*c - D*0.0553*c
C
*     FUNCTION g3
      g3 = -k1*s*(e - c) + D*0.0553*(s0 - s)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION e_0
      e_0 = 0.9
C
*     FUNCTION c_0
      c_0 = 0
C
*     FUNCTION s_0
      s_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION fit
      fit = D*0.0553*e
C
*     FUNCTION e_fit
      e_fit = e
C
*     FUNCTION c_fit
      c_fit = c
C
*     FUNCTION s_fit
      s_fit = s
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
