C
C------------------------------------------------------
C
C     Problem:    CHEMO
C
C     Date:       17.09.97
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      UM, KS, K1, K2, Y, SF, X, S, P, D, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      U=UM*S/(KS + S)
      RX = U*X
      XP = -D*X + RX
C
*     FUNCTION SP
      RS = -RX/Y
      SP = D*(SF - S) + RS
C
*     FUNCTION PP
      RP = (K1 + K2*U)*X
      PP = -D*P + RP
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0
      X0 = 1
C
*     FUNCTION S0 
      S0 = 10
C
*     FUNCTION P0
      P0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION XFIT
      XFIT = X
C
*     FUNCTION SFIT
      SFIT = S
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


