C
C------------------------------------------------------
C
C     Problem:     CHARGE
C
C     Date:        21.06.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R       = 8.3144
      T       = 298.15
      RT      = R*T
      F       = 96485
      eps     = 78*8.854E-12
      ZNa     = 1
      ZCl     = -1
      ZH      = 1
      ZOH     = 1
      scKpd   = 1E-17
      scKpa   = 1D-6
      scKNa   = 1D-3
      scKCl   = 1D-4
      sccstot = 1D-6
      cbCl    = 1.0E-3
      KCl     = 4.37
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Kpd, Kpa, KNa, cstot, zeta, pH
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION equation
      sKpd   = Kpd*scKpd
      sKpa   = Kpa*scKpa
      sKNa   = KNa*scKNa
      sKCl   = KCl*scKCl
      scstot = cstot*sccstot
      cbNa   = cbCl
      cbH    = exp(-pH)
      cbOH   = exp(pH-14)
      eH     = exp(-ZH*F/RT*zeta)
      eOH    = exp(-ZOH*F/RT*zeta)
      eCl    = exp(-ZCl*F/RT*zeta)
      eNa    = exp(-ZNa*F/RT*zeta)
      csH    = cbH*eH
      csOH   = cbOH*eOH
      csCl   = cbCl*eCl
      csNa   = cbNa*eNa
      s      = cbH*(eH-1) + cbOH*(eOH-1) + cbCl*(eCl-1) + cbNa*(eNa-1)
      equation = 2*RT*eps*s 
     /                               - F*scstot*(csH**2 - sKpa*sKpd)
     /       /(sKpa*csH + csH**2 + sKpa*sKpd*(1+csNa/sKCl) + 
     /                                            csH**2*csCl/sKNa)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION zeta_0
      if (pH.lt.8) then
        zeta_0 = 0.001
      else
        zeta_0 = -0.001
      endif
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION fit
      fit = zeta
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


