C
C------------------------------------------------------
C
C     Problem:    CHAN_FLOW
C
C     Date:       13.03.2001
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      R, upp0, uppp0, u, up, upp, uppp, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION u_p
      u_p = up
C
*     FUNCTION up_p
      up_p = upp
C
*     FUNCTION upp_p
      upp_p = uppp
C
*     FUNCTION uppp_p
      uppp_p = R*(up*upp - u*uppp)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION u_0
      u_0 = 0
C
*     FUNCTION up_0
      up_0 = 0
C
*     FUNCTION upp_0
      upp_0 = upp0
C
*     FUNCTION uppp_0
      uppp_0 = uppp0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit
      u_fit = u
C
*     FUNCTION up_fit
      up_fit = up
C
*     FUNCTION upp_fit
      upp_fit = upp
C
*     FUNCTION uppp_fit
      uppp_fit = uppp
C
C------------------------------------------------------
C
C   - Constraints:
C
*     FUNCTION g1
      g1 = u - 1
C
*     FUNCTION g2
      g2 = up 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
