C
C------------------------------------------------------
C
C     Problem:    CHANNEL
C
C     Date:       10.2.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R = 10
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      w0, a, b, u, v, w, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION u_t
      u_t = v
C
*     FUNCTION v_t
      v_t = w
C
*     FUNCTION w_t
      w_t = R*(v**2 - b*u*w - a)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION u_0
      u_0 = 0
C
*     FUNCTION v_0
      v_0 = 0
C
*     FUNCTION w_0
      w_0 = w0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit
      u_fit = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION u_right
      u_right = u - 1
C
*     FUNCTION v_right
      v_right = v
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
