C
C------------------------------------------------------
C
C     Problem:    CHAIN_O1
C
C     Date:       18.11.1994
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, K3, K4, YA, YB, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION YAP
      YAP=-K1*YA + K2*YB
C
*     FUNCTION YBP
      YBP=K1*YA - (K2 + K3)*YB + K4
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION YA0
      YA0=1.0
C
*     FUNCTION YB0
      YB0=0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION YAFIT
      YAFIT=YA
C
*     FUNCTION YBFIT
      YBFIT=YB
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

