C
C------------------------------------------------------
C
C     Problem:     CENTRI
C
C     Date:        23.11.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      q = 0.26
      omega = 1047.2
      R = 8.314E7
      t = 298.15
      A = (q*omega**2)/(2*R*t)
      rh = 6.7
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (z)
C     3. time variable (t)
C
*     VARIABLE
      B, ch, M, c, rx
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION c_eq
      c_eq = ch*exp(A*M*(rx**2 - rh**2)/(1 + M*B*c)) - c
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION c_0
      c_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION c_fit
      c_fit = c
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
