C
C------------------------------------------------------
C
C     Problem:    CELLS
C
C     Date:       06.11.00
C
C------------------------------------------------------
C
*     REAL CONSTANT
      romax = 85
      yco = 0.897
      ypx = 0.0673
      VL = 1
      kL = 0.0137
      os = 86.2
C
C------------------------------------------------------
C
*     LININT Rf
      0.0   0.05
      5.0   0.0
      15.0  0.0
      18.0  0.5
      22.0  0.0
      25.0  0.0
      27.5  0.3
      30.0  0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      rsmax, ks, ko, yxs, mum, x, s, p, o, c, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t  
      rs = rsmax*s/(ks + s)
      mu = yxs*rs - mum
      x_t = mu*x
C
*     FUNCTION s_t
      s_t = -rs*x + 10*Rf(t)
C
*     FUNCTION p_t
      rp = ypx*mu
      p_t = rp*x
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_equ1
      ro = romax*o/(ko + o)
      alg_equ1 = ro*x - (os - o)*kL*VL
C
*     FUNCTION alg_equ2
      rc = yco*ro
      alg_equ2 = c - rc*x/VL
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      if (t.lt.1) then
        x_0 = 4
      else
        x_0 = x
      endif
C
*     FUNCTION s_0
      if (t.lt.1) then
        s_0 = 50
      else
        s_0 = s
      endif
C
*     FUNCTION p_0
      if (t.lt.1) then
        p_0 = 5
      else
        p_0 = p
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION o_0
      if (t.lt.1) then
        o_0 = 80
      else
        o_0 = o
      endif
C
*     FUNCTION c_0
      if (t.lt.1) then
        c_0 = 5
      else
        c_0 = o
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION s_fit
      s_fit = s
C
*     FUNCTION p_fit
      p_fit = p
C
*     FUNCTION o_fit
      o_fit = o
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



