C
C------------------------------------------------------
C
C     Problem:    CAV_BUBB
C
C     Date:       23.11.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R0 = 0.001
      gamma = 1.4
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      star1, a1, D1, y1, y2, s
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_s
      y1_s = y2
C
*     FUNCTION y2_s
      star = star1/R0*1.0E-2
      a = a1/R0*1.0E-5
      D = D1/R0*1.0E-4
      y2_s = (5*exp(-s/star) - 1 - 1.5*y2**2)/y1 
     /      - (a*y2 + D)/y1**2 + (1 + D)/y1**(3*gamma+1)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 1
C
*     FUNCTION y2_0
      y2_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



